/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import si.nevensrok.common.documents.common.Alignment;
import si.nevensrok.common.documents.common.BorderMargin;
import si.nevensrok.common.documents.common.Content;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.documents.common.Heading;
import si.nevensrok.common.documents.common.Image;
import si.nevensrok.common.documents.common.PageBreak;
import si.nevensrok.common.documents.common.PageDirection;
import si.nevensrok.common.documents.common.PageSize;
import si.nevensrok.common.documents.common.Paragraph;
import si.nevensrok.common.documents.common.Table;
import si.nevensrok.common.documents.common.TableCell;
import si.nevensrok.common.documents.common.TableRow;
import si.nevensrok.common.documents.common.VerticalAlignment;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.server.reports.impl.CategoryData;
import si.nevensrok.jtekma.server.reports.impl.CategoryPlacingData;
import si.nevensrok.jtekma.server.reports.impl.MatchData;
import si.nevensrok.jtekma.server.reports.impl.MatchTreeImageGenerator;
import si.nevensrok.jtekma.server.reports.impl.PlacingData;

public class DocumentGenerator {
    private MessageLoader messageLoader;
    private MatchTreeImageGenerator matchTreeImageGenerator;

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public void setMatchTreeImageGenerator(MatchTreeImageGenerator matchTreeImageGenerator) {
        this.matchTreeImageGenerator = matchTreeImageGenerator;
    }

    public Document generateClubPlacingsDocument(Locale locale, List<PlacingData> placings) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "clubPlacing.title"), Heading.HeadingType.H1));
        for (PlacingData placingData : placings) {
            StringBuilder line = new StringBuilder();
            line.append(placingData.getPlacing());
            line.append(". ");
            line.append(placingData.getName());
            line.append(", ");
            line.append(placingData.getPoints());
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "clubPlacing.points"));
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateCompetitorPlacingsDocument(Locale locale, List<CategoryPlacingData> categoryPlacingDataList, boolean oneCategoryPerPage) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryPlacingData categoryPlacingData : categoryPlacingDataList) {
            if (firstCategory) {
                firstCategory = false;
            } else if (oneCategoryPerPage) {
                document.addContent((Content)new PageBreak());
            }
            document.addContent((Content)new Heading(categoryPlacingData.getCategoryName(), Heading.HeadingType.H1));
            for (PlacingData placingData : categoryPlacingData.getPlacingDatas()) {
                StringBuilder line = new StringBuilder();
                line.append(placingData.getPlacing());
                line.append(". ");
                line.append(placingData.getName());
                Paragraph paragraph = new Paragraph(line.toString());
                paragraph.setMargin(new BorderMargin());
                document.addContent((Content)paragraph);
            }
        }
        return document;
    }

    public Document generateTreeReport(Locale locale, List<CategoryData> categoryDatas, boolean empty) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryData categoryData : categoryDatas) {
            if (firstCategory) {
                firstCategory = false;
            } else if (categoryData.getMatchDatas().size() == 28) {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            } else {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            }
            document.addContent((Content)new Heading(categoryData.getCategoryName(), Heading.HeadingType.H1));
            String[][] tableContent = categoryData.getTableContent();
            if (tableContent != null && (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5)) {
                Table table = new Table();
                document.addContent((Content)table);
                float fontSize = 8.0f;
                String[][] tableRow = new TableRow();
                table.addTableRow((TableRow)tableRow);
                TableCell competitorTableCell = new TableCell();
                competitorTableCell.setWidth(7.0f);
                Paragraph competitorParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                competitorParagraph.setFontSize(Float.valueOf(fontSize));
                competitorParagraph.setBold(Boolean.TRUE);
                competitorTableCell.addContent(competitorParagraph);
                tableRow.addTableCell(competitorTableCell);
                for (int i = 1; i <= 5; ++i) {
                    TableCell matchTableCell = new TableCell();
                    matchTableCell.setWidth(3.0f);
                    matchTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph matchParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.match") + " " + i);
                    matchParagraph.setFontSize(Float.valueOf(fontSize));
                    matchParagraph.setBold(Boolean.TRUE);
                    matchParagraph.setAlignment(Alignment.CENTER);
                    matchTableCell.addContent(matchParagraph);
                    tableRow.addTableCell(matchTableCell);
                }
                TableCell winsTableCell = new TableCell();
                winsTableCell.setWidth(3.0f);
                winsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph winsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.wins"));
                winsParagraph.setFontSize(Float.valueOf(fontSize));
                winsParagraph.setBold(Boolean.TRUE);
                winsParagraph.setAlignment(Alignment.CENTER);
                winsTableCell.addContent(winsParagraph);
                tableRow.addTableCell(winsTableCell);
                TableCell fiWinsTableCell = new TableCell();
                fiWinsTableCell.setWidth(3.0f);
                fiWinsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph fiWinsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.fiWins"));
                fiWinsParagraph.setFontSize(Float.valueOf(fontSize));
                fiWinsParagraph.setBold(Boolean.TRUE);
                fiWinsParagraph.setAlignment(Alignment.CENTER);
                fiWinsTableCell.addContent(fiWinsParagraph);
                tableRow.addTableCell(fiWinsTableCell);
                TableCell pointsTableCell = new TableCell();
                pointsTableCell.setWidth(3.0f);
                pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                pointsParagraph.setFontSize(Float.valueOf(fontSize));
                pointsParagraph.setBold(Boolean.TRUE);
                pointsParagraph.setAlignment(Alignment.CENTER);
                pointsTableCell.addContent(pointsParagraph);
                tableRow.addTableCell(pointsTableCell);
                for (String[] row : tableContent) {
                    TableRow tableRow2 = new TableRow();
                    table.addTableRow(tableRow2);
                    TableCell competitorTableCell2 = new TableCell();
                    competitorTableCell2.setWidth(7.0f);
                    Paragraph competitorParagraph2 = new Paragraph(row[0]);
                    competitorParagraph2.setFontSize(Float.valueOf(fontSize));
                    competitorTableCell2.addContent(competitorParagraph2);
                    tableRow2.addTableCell(competitorTableCell2);
                    for (int i = 1; i <= 5; ++i) {
                        TableCell matchTableCell = new TableCell();
                        matchTableCell.setWidth(3.0f);
                        Paragraph matchParagraph = new Paragraph(row[i]);
                        matchParagraph.setFontSize(Float.valueOf(fontSize));
                        matchParagraph.setAlignment(Alignment.CENTER);
                        matchTableCell.addContent(matchParagraph);
                        tableRow2.addTableCell(matchTableCell);
                    }
                    TableCell winsTableCell2 = new TableCell();
                    winsTableCell2.setWidth(3.0f);
                    Paragraph winsParagraph2 = new Paragraph(row[6]);
                    winsParagraph2.setFontSize(Float.valueOf(fontSize));
                    winsParagraph2.setAlignment(Alignment.CENTER);
                    winsTableCell2.addContent(winsParagraph2);
                    tableRow2.addTableCell(winsTableCell2);
                    TableCell fiWinsTableCell2 = new TableCell();
                    fiWinsTableCell2.setWidth(3.0f);
                    Paragraph fiWinsParagraph2 = new Paragraph(row[7]);
                    fiWinsParagraph2.setFontSize(Float.valueOf(fontSize));
                    fiWinsParagraph2.setAlignment(Alignment.CENTER);
                    fiWinsTableCell2.addContent(fiWinsParagraph2);
                    tableRow2.addTableCell(fiWinsTableCell2);
                    TableCell pointsTableCell2 = new TableCell();
                    pointsTableCell2.setWidth(3.0f);
                    Paragraph pointsParagraph2 = new Paragraph(row[8]);
                    pointsParagraph2.setFontSize(Float.valueOf(fontSize));
                    pointsParagraph2.setAlignment(Alignment.CENTER);
                    pointsTableCell2.addContent(pointsParagraph2);
                    tableRow2.addTableCell(pointsTableCell2);
                }
            }
            if (categoryData.getMatchDatas() != null) {
                if (!categoryData.isCustom()) {
                    Image imageContent;
                    BufferedImage image;
                    if (categoryData.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
                        image = this.matchTreeImageGenerator.generateBestOf3Fights(categoryData.getMatchDatas());
                        Image imageContent2 = new Image(image, Alignment.CENTER);
                        imageContent2.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent2);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5) {
                        image = this.matchTreeImageGenerator.generateTableFights(categoryData.getMatchDatas());
                        Image imageContent3 = new Image(image, Alignment.CENTER);
                        imageContent3.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent3);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE4) {
                        boolean display3rdplace = categoryData.isDisplay3rdPlaceMatch();
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.NONE) {
                            display3rdplace = false;
                        }
                        BufferedImage image2 = this.matchTreeImageGenerator.generateTree4Fights(categoryData.getMatchDatas(), display3rdplace);
                        imageContent = new Image(image2, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE8) {
                        boolean displayRepassage = categoryData.getRepassageType() != TreeCategory.RepassageType.NONE;
                        BufferedImage image3 = this.matchTreeImageGenerator.generateTree8Fights(categoryData.getMatchDatas(), displayRepassage, categoryData.isDisplay3rdPlaceMatch());
                        imageContent = new Image(image3, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE16) {
                        image = this.matchTreeImageGenerator.generateTree16Fights(categoryData.getMatchDatas());
                        Image imageContent4 = new Image(image, Alignment.CENTER);
                        imageContent4.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent4);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage")));
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree16RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent4 = new Image(imageRepasague, Alignment.CENTER);
                            imageContent4.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent4);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE32) {
                        image = this.matchTreeImageGenerator.generateTree32Fights(categoryData.getMatchDatas());
                        Image imageContent5 = new Image(image, Alignment.CENTER);
                        imageContent5.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent5);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree32RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent5 = new Image(imageRepasague, Alignment.CENTER);
                            document.addContent((Content)imageContent5);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE64) {
                        Paragraph firstPartParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.firstPart"));
                        firstPartParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)firstPartParagraph);
                        BufferedImage image4 = this.matchTreeImageGenerator.generateTree64_1Fights(categoryData.getMatchDatas());
                        imageContent = new Image(image4, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        Paragraph secondPartParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.secondPart"));
                        secondPartParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)secondPartParagraph);
                        image4 = this.matchTreeImageGenerator.generateTree64_2Fights(categoryData.getMatchDatas());
                        imageContent = new Image(image4, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageFirstPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree64_1RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageSecondPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            imageRepasague = this.matchTreeImageGenerator.generateTree64_2RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                        }
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            Paragraph forThirdParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.forThirdPlace"));
                            forThirdParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)forThirdParagraph);
                            image4 = this.matchTreeImageGenerator.generateTree64ForThirdFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent = new Image(image4, Alignment.LEFT);
                            imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                            document.addContent((Content)imageContent);
                        }
                        Paragraph finalsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.finals"));
                        finalsParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)finalsParagraph);
                        image4 = this.matchTreeImageGenerator.generateTree64FinalsFights(categoryData.getMatchDatas());
                        imageContent = new Image(image4, Alignment.LEFT);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                    }
                } else {
                    BufferedImage image;
                    LinkedList<MatchData> matchesLeft = new LinkedList<MatchData>(categoryData.getMatchDatas());
                    LinkedList<MatchData> matchesToAdd = new LinkedList<MatchData>();
                    while (!matchesLeft.isEmpty()) {
                        matchesToAdd.add(matchesLeft.poll());
                        if (matchesToAdd.size() != 3) continue;
                        image = this.matchTreeImageGenerator.generateMatchRowFights(matchesToAdd);
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        matchesToAdd.clear();
                    }
                    if (!matchesToAdd.isEmpty()) {
                        image = this.matchTreeImageGenerator.generateMatchRowFights(matchesToAdd);
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                    }
                }
            }
            if (categoryData.getPlacingDatas() == null || categoryData.getPlacingDatas().isEmpty()) continue;
            if (categoryData.getPlacingDatas().size() > 16 && categoryData.getPlacingDatas().size() < 33) {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            }
            Paragraph placingParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.placing"));
            placingParagraph.setBold(Boolean.TRUE);
            document.addContent((Content)placingParagraph);
            for (PlacingData placingData : categoryData.getPlacingDatas()) {
                StringBuilder line = new StringBuilder();
                line.append(placingData.getPlacing());
                line.append(". ");
                line.append(placingData.getName());
                Paragraph paragraph = new Paragraph(line.toString());
                paragraph.setMargin(new BorderMargin());
                document.addContent((Content)paragraph);
            }
        }
        return document;
    }
}

