/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.exporters;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.schema.competition.CompetitionData;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryGroupManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.ClubManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.CompetitorManager;
import si.nevensrok.jtekma.server.management.FightInfoManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.NextMatchUploadManager;
import si.nevensrok.jtekma.server.management.SemaphoreManager;
import si.nevensrok.jtekma.server.management.TatamiHistoryManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;
import si.nevensrok.jtekma.server.management.WeightCategoryOptionManager;

public abstract class CompetitionExporter {
    private static final Logger log = LoggerFactory.getLogger(CompetitionExporter.class);
    private DatatypeFactory datatypeFactory;
    private Long competitionId;
    private CompetitionManager competitionManager;
    private ClubManager clubManager;
    private CategoryManager categoryManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private WeightCategoryOptionManager weightCategoryOptionManager;
    private TreeAdvancmentManager treeAdvancmentManager;
    private CompetitorManager competitorManager;
    private MatchManager matchManager;
    private TatamiManager tatamiManager;
    private SemaphoreManager semaphoreManager;
    private FightInfoManager fightInfoManager;
    private NextMatchUploadManager nextMatchUploadManager;
    private CategoryGroupManager categoryGroupManager;
    private TatamiHistoryManager tatamiHistoryManager;
    private Set<String> usedIds = new HashSet<String>();
    private Map<Long, String> clubIds = new HashMap<Long, String>();
    private Map<Long, String> categoryIds = new HashMap<Long, String>();
    private Map<Long, String> ageCategoryIds = new HashMap<Long, String>();
    private Map<Long, String> weightCategoryIds = new HashMap<Long, String>();
    private Map<Long, String> treeAdvancmentIds = new HashMap<Long, String>();
    private Map<Long, String> competitorIds = new HashMap<Long, String>();
    private Map<Long, String> tatamiIds = new HashMap<Long, String>();
    private Map<Long, String> semaphoreIds = new HashMap<Long, String>();

    public CompetitionExporter() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            log.error("Error initializing datatype factory", (Throwable)e);
        }
    }

    public Long getCompetitionId() {
        return this.competitionId;
    }

    public void setCompetitionId(Long competitionId) {
        this.competitionId = competitionId;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public CategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public void setClubManager(ClubManager clubManager) {
        this.clubManager = clubManager;
    }

    public ClubManager getClubManager() {
        return this.clubManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public CompetitionManager getCompetitionManager() {
        return this.competitionManager;
    }

    public AgeCategoryOptionManager getAgeCategoryOptionManager() {
        return this.ageCategoryOptionManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public WeightCategoryOptionManager getWeightCategoryOptionManager() {
        return this.weightCategoryOptionManager;
    }

    public void setWeightCategoryOptionManager(WeightCategoryOptionManager weightCategoryOptionManager) {
        this.weightCategoryOptionManager = weightCategoryOptionManager;
    }

    public TreeAdvancmentManager getTreeAdvancmentManager() {
        return this.treeAdvancmentManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    public CompetitorManager getCompetitorManager() {
        return this.competitorManager;
    }

    public void setCompetitorManager(CompetitorManager competitorManager) {
        this.competitorManager = competitorManager;
    }

    public MatchManager getMatchManager() {
        return this.matchManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public TatamiManager getTatamiManager() {
        return this.tatamiManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public SemaphoreManager getSemaphoreManager() {
        return this.semaphoreManager;
    }

    public void setSemaphoreManager(SemaphoreManager semaphoreManager) {
        this.semaphoreManager = semaphoreManager;
    }

    public FightInfoManager getFightInfoManager() {
        return this.fightInfoManager;
    }

    public void setFightInfoManager(FightInfoManager fightInfoManager) {
        this.fightInfoManager = fightInfoManager;
    }

    public NextMatchUploadManager getNextMatchUploadManager() {
        return this.nextMatchUploadManager;
    }

    public void setNextMatchUploadManager(NextMatchUploadManager nextMatchUploadManager) {
        this.nextMatchUploadManager = nextMatchUploadManager;
    }

    public CategoryGroupManager getCategoryGroupManager() {
        return this.categoryGroupManager;
    }

    public void setCategoryGroupManager(CategoryGroupManager categoryGroupManager) {
        this.categoryGroupManager = categoryGroupManager;
    }

    public TatamiHistoryManager getTatamiHistoryManager() {
        return this.tatamiHistoryManager;
    }

    public void setTatamiHistoryManager(TatamiHistoryManager tatamiHistoryManager) {
        this.tatamiHistoryManager = tatamiHistoryManager;
    }

    public Map<Long, String> getClubIds() {
        return this.clubIds;
    }

    public Map<Long, String> getCategoryIds() {
        return this.categoryIds;
    }

    public Map<Long, String> getAgeCategoryIds() {
        return this.ageCategoryIds;
    }

    public Map<Long, String> getWeightCategoryIds() {
        return this.weightCategoryIds;
    }

    public Map<Long, String> getTreeAdvancmentIds() {
        return this.treeAdvancmentIds;
    }

    public Map<Long, String> getCompetitorIds() {
        return this.competitorIds;
    }

    public Map<Long, String> getTatamiIds() {
        return this.tatamiIds;
    }

    public Map<Long, String> getSemaphoreIds() {
        return this.semaphoreIds;
    }

    public abstract CompetitionData generateCompetitionData();

    public String generateId() {
        for (int i = 0; i < 1000; ++i) {
            String uuid = UUID.randomUUID().toString();
            if (this.usedIds.contains(uuid)) continue;
            this.usedIds.add(uuid);
            return uuid;
        }
        throw new RuntimeException("Error generating UUID");
    }

    public XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return this.datatypeFactory.newXMLGregorianCalendar(calendar);
    }
}

