/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import si.nevensrok.common.map.CaseInsensitiveLinkedHashMap;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.common.restclient.RestApiException;
import si.nevensrok.common.restclient.RestClientUtil;
import si.nevensrok.common.utils.StringUtil;

public class RestResponse
implements Serializable {
    private static final long serialVersionUID = 1499594642365142316L;
    public static final int CODE_CONTINUE = 100;
    public static final int CODE_SWITCHING_PROTOCOLS = 101;
    public static final int CODE_PROCESSING = 102;
    public static final int CODE_OK = 200;
    public static final int CODE_CREATED = 201;
    public static final int CODE_ACCEPTED = 202;
    public static final int CODE_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int CODE_NO_CONTENT = 204;
    public static final int CODE_RESET_CONTENT = 205;
    public static final int CODE_PARTIAL_CONTENT = 206;
    public static final int CODE_MULTI_STATUS = 207;
    public static final int CODE_ALREADY_REPORTED = 208;
    public static final int CODE_IM_USED = 226;
    public static final int CODE_MULTIPLE_CHOICES = 300;
    public static final int CODE_MOVED_PERMANENTLY = 301;
    public static final int CODE_FOUND = 302;
    public static final int CODE_SEE_OTHER = 303;
    public static final int CODE_NOT_MODIFIED = 304;
    public static final int CODE_USE_PROXY = 305;
    public static final int CODE_SWITCH_PROXY = 306;
    public static final int CODE_TEMPORARY_REDIRECT = 307;
    public static final int CODE_PERMANENT_REDIRECT = 308;
    public static final int CODE_BAD_REQUEST = 400;
    public static final int CODE_UNAUTHORIZED = 401;
    public static final int CODE_PAYMENT_REQUIRED = 200;
    public static final int CODE_FORBIDDEN = 403;
    public static final int CODE_NOT_FOUND = 404;
    public static final int CODE_METHOD_NOT_ALLOWER = 405;
    public static final int CODE_NOT_ACCEPTABLE = 406;
    public static final int CODE_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int CODE_REQUEST_TIMEOUT = 408;
    public static final int CODE_CONFLICT = 409;
    public static final int CODE_GONE = 410;
    public static final int CODE_LENGTH_REQUIRED = 411;
    public static final int CODE_PRECONDITION_FAILED = 412;
    public static final int CODE_PAYLOAD_TOO_LARGE = 413;
    public static final int CODE_URI_TOO_LONG = 414;
    public static final int CODE_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int CODE_RANGE_NOT_SATISFIABLE = 416;
    public static final int CODE_EXPECTATION_FAILED = 417;
    public static final int CODE_MISDIRECTED_REQUEST = 421;
    public static final int CODE_UNPROCESSABLE_ENTITY = 422;
    public static final int CODE_LOCKED = 423;
    public static final int CODE_FAILED_DEPENDENCY = 424;
    public static final int CODE_UPGRADE_REQUIRED = 426;
    public static final int CODE_PRECONDITION_REQUIRED = 428;
    public static final int CODE_TOO_MANY_REQUESTS = 429;
    public static final int CODE_REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
    public static final int CODE_UNAVAILABLE_FOR_LEGAL_REASONS = 451;
    public static final int CODE_INTERNAL_SERVER_ERROR = 500;
    public static final int CODE_NOT_IMPLEMENTED = 501;
    public static final int CODE_BAD_GATEWAY = 502;
    public static final int CODE_SERVICE_UNAVAILABLE = 503;
    public static final int CODE_GATEWAY_TIMEOUT = 504;
    public static final int CODE_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final int CODE_VARIANT_ALSO_NEGOTIATES = 506;
    public static final int CODE_INSUFFICIENT_STORAGE = 507;
    public static final int CODE_LOOP_DETECTED = 508;
    public static final int CODE_NOT_EXTENDED = 510;
    public static final int CODE_NETWORK_AUTHENTICATION_REQUIRED = 511;
    private int responseCode = 0;
    private Map<String, List<String>> headers = new CaseInsensitiveLinkedHashMap<List<String>>();
    private byte[] body;

    public RestResponse() {
    }

    public RestResponse(int responseCode) {
        this.responseCode = responseCode;
    }

    public RestResponse(int responseCode, Map<String, List<String>> headers, byte[] body) {
        this.responseCode = responseCode;
        if (headers != null) {
            this.headers.putAll(headers);
        }
        this.body = body;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public boolean isSuccessful() {
        return this.responseCode >= 200 && this.responseCode <= 299;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    public void addHeader(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new LinkedList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public String getContentEncoding() {
        return this.getHeader("Content-Encoding");
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public Long getContentLength() {
        return Long.valueOf(this.getHeader("Content-Length"));
    }

    public String getMimeType() {
        String contentType = this.getContentType();
        if (StringUtil.isNotEmpty((String)contentType)) {
            return RestClientUtil.extractMimeType(contentType);
        }
        return null;
    }

    public String getCharset() {
        String contentType = this.getContentType();
        if (StringUtil.isNotEmpty((String)contentType)) {
            return RestClientUtil.extractCharset(contentType);
        }
        return null;
    }

    public Calendar getDate() {
        String date = this.getHeader("Date");
        if (StringUtil.isNotEmpty((String)date)) {
            return RestClientUtil.parseCalendar(date);
        }
        return null;
    }

    public List<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String getBodyAsString() {
        if (this.getBody() == null) {
            return null;
        }
        String mimeType = this.getMimeType();
        if (StringUtil.isNotEmpty((String)mimeType) && (mimeType.toLowerCase().startsWith("text/") || mimeType.toLowerCase().startsWith("application/json") || mimeType.toLowerCase().startsWith("application/xml"))) {
            String charsetName = this.getCharset();
            if (StringUtil.isEmpty((String)charsetName)) {
                charsetName = "utf8";
            }
            Charset charset = Charset.forName(charsetName);
            return new String(this.getBody(), charset);
        }
        throw new RestApiException("Response body is not of type text");
    }

    public String toString() {
        return new ObjectToString(RestResponse.class).addProperty("responseCode", this.responseCode).addProperty("headers", this.headers).addPropertyLength("body", this.body).generateString();
    }
}

