
/* Drop Tables */

DROP TABLE IF EXISTS monitors;




/* Create Tables */

CREATE TABLE monitors
(
	MonitorName varchar(4096) NOT NULL,
	LockDeadline timestamp with time zone,
	CreatedAt timestamp with time zone NOT NULL,
	MachineIp4 varchar(15),
	MachineIp6 varchar(45),
	MachineHostname varchar(1024),
	MachineName varchar(100),
	ProcessName varchar(1024),
	PRIMARY KEY (MonitorName)
) WITHOUT OIDS;

/* Create indexes */
CREATE INDEX LockDeadlineIndex ON monitors USING BTREE (LockDeadline);

