/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.CertificateChainVerifier;
import si.nevensrok.common.ssl.CertificateRepository;
import si.nevensrok.common.ssl.RevokedCertificateChecker;
import si.nevensrok.common.utils.RegexUtil;
import si.nevensrok.common.x509cert.CertificateUtil;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class CustomTrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = LoggerFactory.getLogger(CustomTrustManager.class);
    private boolean trustAll = false;
    private boolean checkDate = true;
    private boolean checkHostname = true;
    private boolean checkSigningFlag = true;
    private RevokedCertificateChecker revokedCertificateChecker;
    private CertificateRepository certificateRepository;

    public CustomTrustManager() {
    }

    public CustomTrustManager(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public CustomTrustManager(CertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public void setCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
    }

    public void setCheckHostname(boolean checkHostname) {
        this.checkHostname = checkHostname;
    }

    public void setCheckSigningFlag(boolean checkSigningFlag) {
        this.checkSigningFlag = checkSigningFlag;
    }

    public void setRevokedCertificateChecker(RevokedCertificateChecker revokedCertificateChecker) {
        this.revokedCertificateChecker = revokedCertificateChecker;
    }

    public void setCertificateRepository(CertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        LinkedList<X509Certificate> trustedSigners = new LinkedList<X509Certificate>();
        try {
            for (String alias : this.certificateRepository.getAliases()) {
                try {
                    X509Certificate certificate = (X509Certificate)this.certificateRepository.getCertificate(alias);
                    if (this.revokedCertificateChecker != null && this.revokedCertificateChecker.isCertificateRevoked(certificate)) continue;
                    trustedSigners.add(certificate);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.trace("Error fetching accpeted issuers", (Throwable)e);
        }
        return trustedSigners.toArray(new X509Certificate[trustedSigners.size()]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        X509Certificate certificate = this.checkChain(chain);
        if (!this.trustAll && this.checkHostname && socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String hostname = session.getPeerHost();
            if (!this.verifyHostname(hostname, certificate)) {
                throw new CertificateException("Hostname validation failed");
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        X509Certificate certificate = this.checkChain(chain);
        if (!this.trustAll && this.checkHostname && engine != null) {
            SSLSession session = engine.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String hostname = session.getPeerHost();
            if (!this.verifyHostname(hostname, certificate)) {
                throw new CertificateException("Hostname validation failed");
            }
        }
    }

    protected X509Certificate checkChain(X509Certificate[] chain) throws CertificateException {
        if (chain.length < 1) {
            throw new CertificateException("Certificate chain empty");
        }
        if (this.trustAll) {
            return chain[0];
        }
        if (this.certificateRepository == null) {
            throw new CertificateException("Certificate repository empty");
        }
        new CertificateChainVerifier().withCheckDate(this.checkDate).withCheckSigningFlag(this.checkSigningFlag).withCertificateChain(chain).withRevokedCertificateChecker(this.revokedCertificateChecker).withCertificateRepository(this.certificateRepository).check();
        return chain[0];
    }

    public boolean verifyHostname(String hostname, X509Certificate certificate) {
        try {
            if (hostname.startsWith("[") && hostname.endsWith("]")) {
                hostname = hostname.substring(1, hostname.length() - 1);
            }
            X500Name name = CertificateUtil.getName((X509CertImpl)certificate);
            String commonName = name.getCommonName();
            String regex = RegexUtil.createWildcardRegex((String)commonName);
            if (hostname.toLowerCase().matches(regex.toLowerCase())) {
                return true;
            }
            List<String> alternativeNames = CertificateUtil.getAlternativeNames(certificate);
            for (String alternativeName : alternativeNames) {
                String regex2 = RegexUtil.createWildcardRegex((String)alternativeName);
                if (!hostname.toLowerCase().matches(regex2.toLowerCase())) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error("Error checking hostname", (Throwable)e);
        }
        return false;
    }
}

