/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.encryption;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.encryption.AesKeyGenerator;
import si.nevensrok.common.encryption.Decryptor;
import si.nevensrok.common.encryption.Encryptor;
import si.nevensrok.common.utils.StringUtil;

public class AesEncryptorDecryptor
implements Encryptor,
Decryptor,
InitializingBean {
    private SecretKey secretKey;
    private String keyAsString = null;
    private byte[] key = null;
    private int keySize = 0;
    private String chipperInstance = "AES/ECB/PKCS5Padding";
    private Cipher encryptCipher;
    private Cipher decryptCipher;

    public String getKeyAsString() {
        return this.keyAsString;
    }

    public void setKeyAsString(String keyAsString) {
        this.keyAsString = keyAsString;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public void setChipperInstance(String chipperInstance) {
        this.chipperInstance = chipperInstance;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getKey() == null && StringUtil.isEmpty((String)this.getKeyAsString())) {
            throw new IllegalArgumentException("Property 'key' is required");
        }
        this.secretKey = this.getKey() != null ? AesKeyGenerator.generateKey(this.getKey()) : (this.getKeySize() > 0 ? AesKeyGenerator.generateKey(this.getKeyAsString(), this.getKeySize()) : AesKeyGenerator.generateKey(this.getKeyAsString()));
        this.encryptCipher = Cipher.getInstance(this.chipperInstance);
        this.encryptCipher.init(1, this.secretKey);
        this.decryptCipher = Cipher.getInstance(this.chipperInstance);
        this.decryptCipher.init(2, this.secretKey);
    }

    @Override
    public byte[] decrypt(byte[] data) {
        try {
            return this.decryptCipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error decrypting data", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] data) {
        try {
            return this.encryptCipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error encrypting data", e);
        }
    }
}

