/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.fightinfo.FightInfo;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.FightInfoManager;

public class FightInfoImporter {
    private static final int bufferSize = 65536;
    private FightInfoManager fightInfoManager;

    public void setFightInfoManager(FightInfoManager fightInfoManager) {
        this.fightInfoManager = fightInfoManager;
    }

    public List<FightInfo> parseFightInfos(FileType fileType, byte[] fileData) throws Exception {
        LinkedList<FightInfo> fightInfos = new LinkedList<FightInfo>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int fightInfoNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime", "Naziv", "Uporabnik", "Uporabni\u0161ko ime", "Name", "Username"});
        int fightInfoPasswordIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Geslo", "Password"});
        if (fightInfoNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoFightInfoUsername);
        }
        if (fightInfoPasswordIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoFightInfoPassword);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String username = fileLine.getData(fightInfoNameIndex);
            String password = fileLine.getData(fightInfoPasswordIndex);
            if (username == null || username.trim().isEmpty()) continue;
            username = username.trim();
            FightInfo fightInfo = new FightInfo();
            fightInfo.setUsername(username);
            fightInfo.setPassword(password);
            fightInfos.add(fightInfo);
        }
        return fightInfos;
    }

    public void importFightInfos(Competition competition, List<FightInfo> fightInfos) throws Exception {
        for (FightInfo fightInfo : fightInfos) {
            fightInfo.setCompetition(competition);
            if (this.fightInfoManager.getActiveFightInfoByUsername(competition, fightInfo.getUsername()) != null) continue;
            this.fightInfoManager.createFightInfo(fightInfo);
        }
    }

    public byte[] exportFightInfos(FileType fileType, List<FightInfo> fightInfos, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        String[][] fileContent = new String[fightInfos.size() + 1][];
        fileContent[0] = header;
        int i = 1;
        for (FightInfo fightInfo : fightInfos) {
            fileContent[i] = new String[]{fightInfo.getUsername(), ""};
            ++i;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, fileContent);
        return buffer.toByteArray();
    }
}

