/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl.adapters.database;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.dl.CollectionType;
import si.nevensrok.common.dl.Dto;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.adapters.AdapterPool;
import si.nevensrok.common.dl.adapters.AdapterPoolAware;
import si.nevensrok.common.dl.adapters.AdapterProvider;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterPool;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterProvider;
import si.nevensrok.common.dl.adapters.database.FieldInfo;
import si.nevensrok.common.utils.ClassUtil;
import si.nevensrok.common.utils.ObjectUtil;

public class SimpleDatabaseAdapterProvider
implements AdapterProvider<Object, Object>,
DatabaseAdapterProvider<Object, Object>,
AdapterPoolAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDatabaseAdapterProvider.class);
    protected DatabaseAdapterPool adapterPool;
    protected Class<?> fromClass;
    protected Class<?> toClass;
    protected Class<?> simulateToClass = null;
    protected Map<Field, FieldInfo> toFieldInfos = new HashMap<Field, FieldInfo>();

    public SimpleDatabaseAdapterProvider() {
    }

    public SimpleDatabaseAdapterProvider(Class<?> fromClass, Class<?> toClass) {
        this.fromClass = fromClass;
        this.toClass = toClass;
    }

    @Override
    public void setAdapterPool(AdapterPool adapterPool) {
        this.adapterPool = (DatabaseAdapterPool)adapterPool;
    }

    @Override
    public Object create(Object source) {
        try {
            Object to = this.toClass.newInstance();
            for (Field field : this.toFieldInfos.keySet()) {
                Object value;
                FieldInfo fieldInfo = this.toFieldInfos.get(field);
                Field mappingField = fieldInfo.getMappingField();
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Collection fromCollection = (Collection)fieldInfo.getGetter().invoke(source, new Object[0]);
                    HashSet toCollection = null;
                    if (fromCollection instanceof Set) {
                        toCollection = new HashSet();
                    }
                    if (toCollection == null) continue;
                    for (Object fromFata : fromCollection) {
                        Object toData = this.adapterPool.create(fieldInfo.getCollectionType(), fromFata);
                        toCollection.add(toData);
                    }
                    fieldInfo.getSetter().invoke(to, toCollection);
                    continue;
                }
                if (Pojo.class.isAssignableFrom(field.getType()) || Dto.class.isAssignableFrom(field.getType())) {
                    try {
                        if (mappingField == null || (value = fieldInfo.getGetter().invoke(source, new Object[0])) == null) continue;
                        Object fieldValue = this.adapterPool.create(field.getType(), value);
                        fieldInfo.getSetter().invoke(to, fieldValue);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error mapping field " + field.getName(), (Throwable)e);
                    }
                    continue;
                }
                value = fieldInfo.getGetter().invoke(source, new Object[0]);
                if (mappingField == null || value == null) continue;
                fieldInfo.getSetter().invoke(to, value);
            }
            return to;
        }
        catch (Exception e) {
            LOGGER.error("Error while copying data", (Throwable)e);
            return null;
        }
    }

    @Override
    public void applyFilterByExample(StringBuilder sqlQuery, ParamsBinder params, Object example) {
        this.applyFilterByExample(sqlQuery, params, example, true);
    }

    @Override
    public void applyFilterByExample(StringBuilder sqlQuery, ParamsBinder params, Object example, boolean caseSensitive) {
        if (!Dto.class.isAssignableFrom(this.toClass)) {
            throw new UnsupportedOperationException(this.toClass.getName() + " is not sub class from Dto");
        }
        if (example == null) {
            return;
        }
        try {
            StringBuilder sql = new StringBuilder();
            for (Field field : this.toFieldInfos.keySet()) {
                FieldInfo fieldInfo = this.toFieldInfos.get(field);
                Object value = fieldInfo.getGetter().invoke(example, new Object[0]);
                if (value == null) continue;
                String tableFieldName = field.getName();
                if (sql.length() > 0) {
                    sql.append(" and");
                }
                if (field.getGenericType().equals(String.class)) {
                    String val = (String)value;
                    if (val.indexOf(37) >= 0) {
                        if (caseSensitive) {
                            sql.append(" main.");
                            sql.append(tableFieldName);
                            sql.append(" like ");
                            sql.append(params.addParam(val));
                            continue;
                        }
                        sql.append(" UPPER(main.");
                        sql.append(tableFieldName);
                        sql.append(") like UPPER(");
                        sql.append(params.addParam(val));
                        sql.append(")");
                        continue;
                    }
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam(val));
                    continue;
                }
                if (field.getGenericType().equals(Character.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Character)value));
                    continue;
                }
                if (field.getGenericType().equals(Byte.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Byte)value));
                    continue;
                }
                if (field.getGenericType().equals(Short.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Short)value));
                    continue;
                }
                if (field.getGenericType().equals(Integer.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Integer)value));
                    continue;
                }
                if (field.getGenericType().equals(Long.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Long)value));
                    continue;
                }
                if (field.getGenericType().equals(Float.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Float)value));
                    continue;
                }
                if (field.getGenericType().equals(Double.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Double)value));
                    continue;
                }
                if (field.getGenericType().equals(Date.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Date)value));
                    continue;
                }
                if (field.getGenericType().equals(Calendar.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Calendar)value));
                    continue;
                }
                if (field.getGenericType().equals(Boolean.class)) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append("=");
                    sql.append(params.addParam((Boolean)value));
                    continue;
                }
                if (value instanceof Pojo) {
                    sql.append(" main.");
                    sql.append(tableFieldName);
                    sql.append(".id=");
                    Pojo subPojo = (Pojo)value;
                    if (subPojo.getId() instanceof Integer) {
                        sql.append(params.addParam((Integer)subPojo.getId()));
                        continue;
                    }
                    if (subPojo.getId() instanceof Long) {
                        sql.append(params.addParam((Long)subPojo.getId()));
                        continue;
                    }
                    sql.append(params.addParam(subPojo.getId()));
                    continue;
                }
                sql.append(" main.");
                sql.append(tableFieldName);
                sql.append("=");
                sql.append(params.addParam(value));
            }
            if (sql.length() > 0) {
                sqlQuery.append(" (");
                sqlQuery.append((CharSequence)sql);
                sqlQuery.append(")");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error adding example filter", (Throwable)e);
        }
    }

    @Override
    public Class<Object> getFromClass() {
        return this.fromClass;
    }

    public void setFromClass(Class<?> fromClass) {
        this.fromClass = fromClass;
    }

    @Override
    public Class<Object> getToClass() {
        if (this.simulateToClass != null) {
            return this.simulateToClass;
        }
        return this.toClass;
    }

    public void setToClass(Class<?> toClass) {
        this.toClass = toClass;
    }

    public void setSimulateToClass(Class<?> simulateToClass) {
        this.simulateToClass = simulateToClass;
    }

    public Class<?> getSimulateToClass() {
        return this.simulateToClass;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.fromClass == null) {
            throw new IllegalArgumentException("Property 'fromClass' is requied");
        }
        if (this.toClass == null) {
            throw new IllegalArgumentException("Property 'toClass' is requied");
        }
        List<Field> fromFields = null;
        List<Field> toFields = null;
        fromFields = Dto.class.isAssignableFrom(this.fromClass) ? SimpleDatabaseAdapterProvider.getDtoFields(this.fromClass) : SimpleDatabaseAdapterProvider.getPojoFields(this.fromClass);
        toFields = Dto.class.isAssignableFrom(this.toClass) ? SimpleDatabaseAdapterProvider.getDtoFields(this.toClass) : SimpleDatabaseAdapterProvider.getPojoFields(this.toClass);
        for (Field toField : toFields) {
            Method toSetter = SimpleDatabaseAdapterProvider.findSetterMethod(toField);
            Field fromField = null;
            Method fromGetter = null;
            fromField = Dto.class.isAssignableFrom(toField.getType()) ? SimpleDatabaseAdapterProvider.findMappingField(toField.getName(), Pojo.class, fromFields) : (Pojo.class.isAssignableFrom(toField.getType()) ? SimpleDatabaseAdapterProvider.findMappingField(toField.getName(), Dto.class, fromFields) : SimpleDatabaseAdapterProvider.findMappingField(toField.getName(), toField.getType(), fromFields));
            if (fromField != null) {
                fromGetter = SimpleDatabaseAdapterProvider.findGetterMethod(fromField);
            }
            if (toSetter == null || fromField == null || fromGetter == null || this.isMarkedAsLazy(fromField)) continue;
            Class<?> collectionType = null;
            if (Collection.class.isAssignableFrom(toField.getType()) && ((collectionType = this.getCollectionType(toField)) == null || !Pojo.class.isAssignableFrom(collectionType) && !Dto.class.isAssignableFrom(collectionType))) continue;
            this.toFieldInfos.put(toField, new FieldInfo(fromGetter, toSetter, fromField, collectionType));
        }
    }

    protected static Method findSetterMethod(Field field) {
        return ClassUtil.findSetterMethod((Field)field);
    }

    protected static List<Field> getPojoFields(Class c) {
        LinkedList<Field> fields = new LinkedList<Field>();
        Class currentClass = c;
        while (Pojo.class.isAssignableFrom(currentClass)) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                fields.add(declaredFields[i]);
            }
            currentClass = currentClass.getSuperclass();
        }
        return fields;
    }

    protected static List<Field> getDtoFields(Class c) {
        LinkedList<Field> fields = new LinkedList<Field>();
        Class currentClass = c;
        while (Dto.class.isAssignableFrom(currentClass)) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                Field field = declaredFields[i];
                if (!SimpleDatabaseAdapterProvider.isDtoFieldMapped(field)) continue;
                fields.add(field);
            }
            currentClass = currentClass.getSuperclass();
        }
        return fields;
    }

    protected static boolean isDtoFieldMapped(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (annotation instanceof Column) {
                return true;
            }
            if (annotation instanceof JoinColumn) {
                return true;
            }
            if (annotation instanceof OneToMany) {
                return true;
            }
            if (annotation instanceof JoinTable) {
                return true;
            }
            if (!(annotation instanceof OneToOne)) continue;
            return true;
        }
        return false;
    }

    protected static Field findMappingField(String fieldName, Class targetFieldValueClass, List<Field> fields) {
        for (Field field : fields) {
            if (!field.getName().equalsIgnoreCase(fieldName) || !targetFieldValueClass.isAssignableFrom(field.getType())) continue;
            return field;
        }
        return null;
    }

    protected static Object getValue(Field field, Object object) {
        try {
            return ObjectUtil.getValue((Field)field, (Object)object);
        }
        catch (Exception e) {
            LOGGER.error("Error while getting field value for field " + field.getDeclaringClass().getName() + "." + field.getName(), (Throwable)e);
            return null;
        }
    }

    protected static Method findGetterMethod(Field field) {
        return ClassUtil.findGetterMethod((Field)field);
    }

    protected static void setValue(Field field, Object object, Object value) {
        try {
            ObjectUtil.setValue((Field)field, (Object)object, (Object)value);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting field value for field " + field.getDeclaringClass().getName() + "." + field.getName(), (Throwable)e);
        }
    }

    protected boolean isMarkedAsLazy(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (annotation instanceof ManyToOne) {
                ManyToOne manyToOne = (ManyToOne)annotation;
                return manyToOne.fetch() == FetchType.LAZY;
            }
            if (annotation instanceof OneToOne) {
                OneToOne oneToOne = (OneToOne)annotation;
                return oneToOne.fetch() == FetchType.LAZY;
            }
            if (annotation instanceof OneToMany) {
                OneToMany oneToMany = (OneToMany)annotation;
                return oneToMany.fetch() == FetchType.LAZY;
            }
            if (!(annotation instanceof ManyToMany)) continue;
            ManyToMany manyToMany = (ManyToMany)annotation;
            return manyToMany.fetch() == FetchType.LAZY;
        }
        return false;
    }

    protected Class<?> getCollectionType(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!(annotation instanceof CollectionType)) continue;
            CollectionType collectionType = (CollectionType)annotation;
            return collectionType.value();
        }
        return null;
    }
}

