/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.notifications.pushover;

import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.notifications.BackgroundNotificationSender;
import si.nevensrok.common.notifications.Notification;
import si.nevensrok.common.notifications.pushover.PushoverNotification;
import si.nevensrok.common.restclient.RestClient;
import si.nevensrok.common.restclient.RestRequest;
import si.nevensrok.common.restclient.RestResponse;
import si.nevensrok.common.utils.StringUtil;

public class PushoverNotificationSender
extends BackgroundNotificationSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushoverNotificationSender.class);
    private String address = "https://api.pushover.net/1/messages.json";
    private String token;
    private RestClient restClient = new RestClient();

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.restClient.setConnectTimeout(connectTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.restClient.setReadTimeout(readTimeout);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Initializing pushover notification sender");
        if (StringUtil.isEmpty((String)this.getAddress())) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        if (StringUtil.isEmpty((String)this.getToken())) {
            throw new IllegalArgumentException("Property 'token' is required");
        }
        super.afterPropertiesSet();
    }

    @Override
    public void sendNotification(Notification notification) {
        RestRequest restRequest = RestRequest.post(this.getAddress());
        LinkedHashMap<String, String> body = new LinkedHashMap<String, String>();
        body.put("token", this.getToken());
        body.put("user", notification.getReceiver());
        body.put("message", notification.getText());
        body.put("priority", String.valueOf(PushoverNotificationSender.convertPriority(notification.getPriority())));
        if (notification instanceof PushoverNotification) {
            PushoverNotification pushoverNotification = (PushoverNotification)notification;
            if (pushoverNotification.getDevice() != null) {
                body.put("device", pushoverNotification.getDevice());
            }
            if (pushoverNotification.getTitle() != null) {
                body.put("title", pushoverNotification.getTitle());
            }
            if (pushoverNotification.getUrl() != null) {
                body.put("url", pushoverNotification.getUrl());
            }
            if (pushoverNotification.getUrlTitle() != null) {
                body.put("url_title", pushoverNotification.getUrlTitle());
            }
            if (pushoverNotification.getSound() != null) {
                body.put("sound", pushoverNotification.getSound());
            }
            if (pushoverNotification.getTime() != null) {
                body.put("timestamp", String.valueOf(pushoverNotification.getTime().getTimeInMillis()));
            }
        }
        restRequest.setWwwFormUrlEncodedBody(body);
        RestResponse restResponse = this.restClient.execute(restRequest);
        if (!restResponse.isSuccessful()) {
            LOGGER.error("Invalid HTTP response code: {}", (Object)restResponse.getResponseCode());
        }
    }

    private static int convertPriority(Notification.Priority priority) {
        if (priority == Notification.Priority.HIGH) {
            return 1;
        }
        if (priority == Notification.Priority.LOW) {
            return -1;
        }
        return 0;
    }
}

