/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.messagesource;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.messagesource.MessageLoader;

public class MapMessageLoader
implements MessageLoader {
    private static final Logger log = LoggerFactory.getLogger(MapMessageLoader.class);
    private Map<String, Map<String, String>> messages = new LinkedHashMap<String, Map<String, String>>();

    @Override
    public void setMessage(Locale locale, String key, String message) {
        String localeId;
        Map<String, String> messagesMap;
        if (log.isTraceEnabled()) {
            log.trace("Setting message for locale {} with key {} to {}", new Object[]{locale, key, message});
        }
        if ((messagesMap = this.messages.get(localeId = this.getLocaleId(locale))) == null) {
            messagesMap = new LinkedHashMap<String, String>();
            this.messages.put(localeId, messagesMap);
        }
        messagesMap.put(key, message);
    }

    @Override
    public String getMessage(Locale locale, String key) {
        String localeId = this.getLocaleId(locale);
        Map<String, String> messagesMap = this.messages.get(localeId);
        if (messagesMap == null) {
            return null;
        }
        return messagesMap.get(key);
    }

    @Override
    public boolean isMessagePresent(Locale locale, String key) {
        String localeId = this.getLocaleId(locale);
        Map<String, String> messagesMap = this.messages.get(localeId);
        if (messagesMap == null) {
            return false;
        }
        return messagesMap.containsKey(key);
    }

    private String getLocaleId(Locale locale) {
        return locale.toLanguageTag();
    }
}

