/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.uuid;

import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.uuid.UUIDGenerator;
import si.nevensrok.common.uuid.UUIDUtil;

public class MacTimeUUIDGenerator
implements UUIDGenerator,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MacTimeUUIDGenerator.class);
    private byte[] macAddress = null;
    private Integer clockId = null;

    public void setMacAddress(byte[] macAddress) {
        this.macAddress = macAddress;
    }

    public void setMacAddressAsString(String macAddress) {
        this.macAddress = ByteUtil.fromHexString(macAddress);
    }

    public void setClockId(Integer clockId) {
        this.clockId = clockId;
    }

    public void afterPropertiesSet() throws Exception {
        Random random = new Random();
        if (this.macAddress == null) {
            log.debug("Reading MAC address from network card");
            try {
                Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaceEnumerator.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                    if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                    this.macAddress = networkInterface.getHardwareAddress();
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error retriving machine MAC addresses", e);
            }
        }
        if (this.macAddress == null) {
            log.debug("Generating random MAC address");
            this.macAddress = new byte[6];
            random.nextBytes(this.macAddress);
            this.macAddress[0] = 9;
        }
        if (this.macAddress.length != 6) {
            throw new IllegalArgumentException("MAC address [" + ByteUtil.toHexString(this.macAddress) + "] is not 6 bytes long");
        }
        if (this.clockId == null) {
            log.debug("Generating random clock id");
            this.clockId = random.nextInt();
        }
    }

    @Override
    public UUID generateUUID() {
        byte[] uuidBytes = new byte[16];
        long time = System.currentTimeMillis() * 10000L + 122192928000000000L + System.nanoTime() / 100L % 10000L;
        uuidBytes[0] = (byte)(time >> 24 & 0xFFL);
        uuidBytes[1] = (byte)(time >> 16 & 0xFFL);
        uuidBytes[2] = (byte)(time >> 8 & 0xFFL);
        uuidBytes[3] = (byte)(time & 0xFFL);
        uuidBytes[4] = (byte)(time >> 40 & 0xFFL);
        uuidBytes[5] = (byte)(time >> 32 & 0xFFL);
        uuidBytes[6] = (byte)(time >> 56 & 0xFFL);
        uuidBytes[7] = (byte)(time >> 48 & 0xFFL);
        uuidBytes[6] = (byte)(uuidBytes[6] & 0xF);
        uuidBytes[6] = (byte)(uuidBytes[6] | 0x10);
        uuidBytes[8] = (byte)(this.clockId >> 8 & 0xFF);
        uuidBytes[8] = (byte)(uuidBytes[8] & 0x3F);
        uuidBytes[8] = (byte)(uuidBytes[8] | 0x80);
        uuidBytes[9] = (byte)(this.clockId & 0xFF);
        for (int i = 10; i <= 15; ++i) {
            uuidBytes[i] = this.macAddress[i - 10];
        }
        return UUIDUtil.generateFromBytes(uuidBytes);
    }
}

