/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.gui.InfoPanel;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.HorizontalDuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.HorizontalFightPointsPanel;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

@Deprecated
public class HorizontalMatchPanel
extends JPanel
implements InitializingBean,
ApplicationContextAware,
MatchPanel {
    private static final long serialVersionUID = -1513176730832548486L;
    private NumberFormat fightPointsFormat = new DecimalFormat("0");
    private NumberFormat duoPointsFormat = new DecimalFormat("0.0");
    private Color competitor1fgColor = Color.WHITE;
    private Color competitor1bgColor = new Color(0xC00000);
    private Color competitor2fgColor = Color.WHITE;
    private Color competitor2bgColor = new Color(192);
    private JPanel pointsPanel = new JPanel();
    private JLabel points1label = new JLabel();
    private JLabel points2label = new JLabel();
    private JPanel competitorName1panel = new JPanel();
    private JLabel name1label = new JLabel();
    private JPanel competitorName2panel = new JPanel();
    private JLabel name2label = new JLabel();
    private Font nameFont = new Font("Serif", 1, 50);
    private Font pointsFont = new Font("Serif", 1, 120);
    private JPanel centerPointsPanel = new JPanel();
    private InfoPanel infoPanel;
    private HorizontalFightPointsPanel fightPointsPanel;
    private HorizontalDuoPointsPanel duoPointsPanel;
    private MatchData matchData;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setInfoPanel(InfoPanel infoPanel) {
        this.infoPanel = infoPanel;
    }

    public void setFightPointsPanel(HorizontalFightPointsPanel fightPointsPanel) {
        this.fightPointsPanel = fightPointsPanel;
    }

    public void setDuoPointsPanel(HorizontalDuoPointsPanel duoPointsPanel) {
        this.duoPointsPanel = duoPointsPanel;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public HorizontalMatchPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pointsPanel, "East");
        this.pointsPanel.setLayout(new GridLayout(2, 1));
        this.pointsPanel.add(this.points1label);
        this.pointsPanel.add(this.points2label);
        this.points1label.setFont(this.pointsFont);
        this.points2label.setFont(this.pointsFont);
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        this.competitorName1panel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.competitorName1panel, "North");
        this.competitorName1panel.add((Component)this.name1label, "Center");
        this.competitorName2panel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.competitorName2panel, "South");
        this.competitorName2panel.add((Component)this.name2label, "Center");
        this.name1label.setFont(this.nameFont);
        this.name2label.setFont(this.nameFont);
        this.centerPointsPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.centerPointsPanel, "Center");
    }

    public void afterPropertiesSet() throws Exception {
        this.centerPointsPanel.add((Component)this.infoPanel, "West");
        this.redrawElements();
    }

    @Override
    public void redrawElements() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HorizontalMatchPanel.this.pointsPanel.setPreferredSize(new Dimension(350, 0));
                HorizontalMatchPanel.this.pointsPanel.setBackground(HorizontalMatchPanel.this.competitor2bgColor);
                HorizontalMatchPanel.this.points1label.setOpaque(true);
                HorizontalMatchPanel.this.points1label.setForeground(HorizontalMatchPanel.this.competitor1fgColor);
                HorizontalMatchPanel.this.points1label.setBackground(HorizontalMatchPanel.this.competitor1bgColor);
                HorizontalMatchPanel.this.points1label.setHorizontalAlignment(0);
                HorizontalMatchPanel.this.points2label.setOpaque(true);
                HorizontalMatchPanel.this.points2label.setForeground(HorizontalMatchPanel.this.competitor2fgColor);
                HorizontalMatchPanel.this.points2label.setBackground(HorizontalMatchPanel.this.competitor2bgColor);
                HorizontalMatchPanel.this.points2label.setHorizontalAlignment(0);
                HorizontalMatchPanel.this.competitorName1panel.setPreferredSize(new Dimension(0, 200));
                HorizontalMatchPanel.this.name1label.setBackground(HorizontalMatchPanel.this.competitor1bgColor);
                HorizontalMatchPanel.this.name1label.setForeground(HorizontalMatchPanel.this.competitor1fgColor);
                HorizontalMatchPanel.this.name1label.setOpaque(true);
                HorizontalMatchPanel.this.name1label.setHorizontalAlignment(0);
                HorizontalMatchPanel.this.competitorName2panel.setPreferredSize(new Dimension(0, 200));
                HorizontalMatchPanel.this.name2label.setBackground(HorizontalMatchPanel.this.competitor2bgColor);
                HorizontalMatchPanel.this.name2label.setForeground(HorizontalMatchPanel.this.competitor2fgColor);
                HorizontalMatchPanel.this.name2label.setOpaque(true);
                HorizontalMatchPanel.this.name2label.setHorizontalAlignment(0);
                HorizontalMatchPanel.this.infoPanel.setPreferredSize(new Dimension(190, 0));
                String competitor1 = HorizontalMatchPanel.this.matchData.getName1();
                if (!HorizontalMatchPanel.this.matchData.getClub1().isEmpty()) {
                    if (!competitor1.isEmpty()) {
                        competitor1 = competitor1 + " / ";
                    }
                    competitor1 = competitor1 + HorizontalMatchPanel.this.matchData.getClub1();
                }
                HorizontalMatchPanel.this.name1label.setText(competitor1);
                FontSizeUtil.refitFontSize(HorizontalMatchPanel.this.nameFont, HorizontalMatchPanel.this.name1label);
                String competitor2 = HorizontalMatchPanel.this.matchData.getName2();
                if (!HorizontalMatchPanel.this.matchData.getClub2().isEmpty()) {
                    if (!competitor2.isEmpty()) {
                        competitor2 = competitor2 + " / ";
                    }
                    competitor2 = competitor2 + HorizontalMatchPanel.this.matchData.getClub2();
                }
                HorizontalMatchPanel.this.name2label.setText(competitor2);
                FontSizeUtil.refitFontSize(HorizontalMatchPanel.this.nameFont, HorizontalMatchPanel.this.name2label);
                if (HorizontalMatchPanel.this.matchData.getTableType() == TableType.FIGHT) {
                    boolean change = true;
                    for (Component component : HorizontalMatchPanel.this.centerPointsPanel.getComponents()) {
                        if (component == HorizontalMatchPanel.this.fightPointsPanel) {
                            change = false;
                            break;
                        }
                        if (component != HorizontalMatchPanel.this.duoPointsPanel) continue;
                        HorizontalMatchPanel.this.centerPointsPanel.remove(component);
                        break;
                    }
                    if (change) {
                        HorizontalMatchPanel.this.centerPointsPanel.add((Component)HorizontalMatchPanel.this.fightPointsPanel, "Center");
                        HorizontalMatchPanel.this.revalidate();
                        HorizontalMatchPanel.this.repaint();
                        HorizontalMatchPanel.this.fightPointsPanel.redrawElements();
                    }
                } else {
                    boolean change = true;
                    for (Component component : HorizontalMatchPanel.this.centerPointsPanel.getComponents()) {
                        if (component == HorizontalMatchPanel.this.duoPointsPanel) {
                            change = false;
                            break;
                        }
                        if (component != HorizontalMatchPanel.this.fightPointsPanel) continue;
                        HorizontalMatchPanel.this.centerPointsPanel.remove(component);
                        break;
                    }
                    if (change) {
                        HorizontalMatchPanel.this.centerPointsPanel.add((Component)HorizontalMatchPanel.this.duoPointsPanel, "Center");
                        HorizontalMatchPanel.this.revalidate();
                        HorizontalMatchPanel.this.repaint();
                        HorizontalMatchPanel.this.duoPointsPanel.redrawElements();
                    }
                }
            }
        });
        this.fightPointsPanel.redrawElements();
        this.duoPointsPanel.redrawElements();
        this.infoPanel.redrawElements();
    }

    @Override
    public void setPoints1(float points) {
        final String text = this.matchData.getTableType() == TableType.FIGHT ? this.fightPointsFormat.format(points) : this.duoPointsFormat.format(points);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HorizontalMatchPanel.this.points1label.setText(text);
                FontSizeUtil.refitFontSize(HorizontalMatchPanel.this.pointsFont, HorizontalMatchPanel.this.points1label);
            }
        });
    }

    @Override
    public void setPoints2(float points) {
        final String text = this.matchData.getTableType() == TableType.FIGHT ? this.fightPointsFormat.format(points) : this.duoPointsFormat.format(points);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HorizontalMatchPanel.this.points2label.setText(text);
                FontSizeUtil.refitFontSize(HorizontalMatchPanel.this.pointsFont, HorizontalMatchPanel.this.points2label);
            }
        });
    }

    @Override
    public void setWinner1() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HorizontalMatchPanel.this.name1label.setText(HorizontalMatchPanel.this.getLanguageText("text.winner"));
                FontSizeUtil.refitFontSize(HorizontalMatchPanel.this.nameFont, HorizontalMatchPanel.this.name1label);
                HorizontalMatchPanel.this.name2label.setText("");
            }
        });
    }

    @Override
    public void setWinner2() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HorizontalMatchPanel.this.name2label.setText(HorizontalMatchPanel.this.getLanguageText("text.winner"));
                FontSizeUtil.refitFontSize(HorizontalMatchPanel.this.nameFont, HorizontalMatchPanel.this.name2label);
                HorizontalMatchPanel.this.name1label.setText("");
            }
        });
    }
}

