/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.servlet.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.web.filter.GenericFilterBean;
import si.nevensrok.common.web.servlet.security.AdditionalSecurityProvider;
import si.nevensrok.common.webserver.ServletUtil;

public class AdditionalSecurityFilter
extends GenericFilterBean {
    private Logger log = LoggerFactory.getLogger(AdditionalSecurityFilter.class);
    private static final String ATTRIBUTEPREFIX = "ASF_";
    private AdditionalSecurityProvider additionalSecurityProvider;
    private boolean afterNormalAuthentication = true;
    private String loginPage;
    private String successPage = "/";
    private String failurePage;
    private String codeParameter = "securityCode";
    private String[] allowPages;
    private String[] protectPages;
    private RememberMeServices rememberMeServices;

    public void setAdditionalSecurityProvider(AdditionalSecurityProvider additionalSecurityProvider) {
        this.additionalSecurityProvider = additionalSecurityProvider;
    }

    public void setAfterNormalAuthentication(boolean afterNormalAuthentication) {
        this.afterNormalAuthentication = afterNormalAuthentication;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public void setSuccessPage(String successPage) {
        this.successPage = successPage;
    }

    public void setFailurePage(String failurePage) {
        this.failurePage = failurePage;
    }

    public void setCodeParameter(String codeParameter) {
        this.codeParameter = codeParameter;
    }

    public void setAllowPages(String[] allowPages) {
        this.allowPages = allowPages;
    }

    public void setProtectPages(String[] protectPages) {
        this.protectPages = protectPages;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public void afterPropertiesSet() throws ServletException {
        if (this.additionalSecurityProvider == null) {
            throw new IllegalArgumentException("Property 'additionalSecurityProvider' is requied");
        }
        if (this.loginPage == null) {
            throw new IllegalArgumentException("Property 'loginPage' is requied");
        }
        super.afterPropertiesSet();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object principal;
        String filterName = this.getFilterName();
        this.log.trace("Do filter: {}", (Object)filterName);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null && this.afterNormalAuthentication) {
            this.log.trace("Not checking - normal authentication requied");
            chain.doFilter(request, response);
            return;
        }
        if (!authentication.isAuthenticated() && this.afterNormalAuthentication) {
            this.log.trace("Not checking - normal authentication requied");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpSession httpSession = httpServletRequest.getSession();
        boolean isAuthenticated = false;
        if (httpSession.getAttribute(ATTRIBUTEPREFIX + filterName) != null) {
            isAuthenticated = true;
        }
        this.log.trace("Is authenticated: {}", (Object)isAuthenticated);
        String requestURI = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        if (!contextPath.isEmpty() && requestURI.startsWith(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        this.log.trace("RequestURI: {}", (Object)requestURI);
        if (this.loginPage.equals(requestURI)) {
            if (isAuthenticated) {
                this.log.trace("Already authenticated - redirecting to success page");
                httpServletResponse.sendRedirect(contextPath + this.successPage);
                return;
            }
            principal = authentication.getPrincipal();
            if (!this.additionalSecurityProvider.isSecurityCheckNeeded(principal)) {
                this.log.trace("Security check not needed - redirecting to success page");
                httpServletResponse.sendRedirect(contextPath + this.successPage);
                return;
            }
            if (httpServletRequest.getMethod().equalsIgnoreCase("POST")) {
                this.log.trace("Cheking security code");
                String securityCode = httpServletRequest.getParameter(this.codeParameter);
                if (this.additionalSecurityProvider.checkSecurityCode(principal, securityCode)) {
                    this.log.trace("Correct security code - redirecting to success page");
                    httpSession.setAttribute(ATTRIBUTEPREFIX + filterName, (Object)Boolean.TRUE);
                    if (this.rememberMeServices != null) {
                        this.log.trace("Notifying remember me service");
                        this.rememberMeServices.loginSuccess(httpServletRequest, httpServletResponse, authentication);
                    }
                    httpServletResponse.sendRedirect(contextPath + this.successPage);
                    return;
                }
                this.log.trace("Invalid security code - redirecting to failure page");
                this.additionalSecurityProvider.invalidSecurityCodeEntered(principal);
                if (this.failurePage != null) {
                    httpServletResponse.sendRedirect(contextPath + this.failurePage);
                } else {
                    httpServletResponse.sendRedirect(contextPath + this.loginPage);
                }
                return;
            }
            if (httpServletRequest.getMethod().equalsIgnoreCase("GET")) {
                this.log.trace("Send security code to user: [{}]", principal);
                this.additionalSecurityProvider.sendSecurityCodeToUser(principal);
                chain.doFilter(request, response);
                return;
            }
        }
        if (!isAuthenticated) {
            principal = authentication.getPrincipal();
            if (this.allowPages != null && !ServletUtil.matchesMapping(requestURI, this.allowPages) && (this.protectPages == null || ServletUtil.matchesMapping(requestURI, this.protectPages)) && this.additionalSecurityProvider.isSecurityCheckNeeded(principal)) {
                this.log.trace("Redirecting to login page");
                httpServletResponse.sendRedirect(contextPath + this.loginPage);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void addUserAuthenticatedFlag(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute(ATTRIBUTEPREFIX + this.getFilterName(), (Object)Boolean.TRUE);
    }

    public boolean isUserAuthenticated(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        return httpSession.getAttribute(ATTRIBUTEPREFIX + this.getFilterName()) != null;
    }
}

