/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.formatter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import si.nevensrok.common.web.formatter.AbstractFormatterFactory;
import si.nevensrok.common.web.formatter.DateFormatter;
import si.nevensrok.common.web.formatter.TimezoneResolver;

public class DateFormatterFactory
extends AbstractFormatterFactory<DateFormatter> {
    private TimezoneResolver timezoneResolver;

    public void setTimezoneResolver(TimezoneResolver timezoneResolver) {
        this.timezoneResolver = timezoneResolver;
    }

    public DateFormatterFactory() {
        super(new Class[]{Date.class, Calendar.class});
    }

    public Printer<?> getPrinter(final DateFormatter annotation, Class<?> fieldType) {
        if (Date.class.isAssignableFrom(fieldType)) {
            return new Printer<Date>(){

                public String print(Date date, Locale locale) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.format(date);
                }
            };
        }
        if (Calendar.class.isAssignableFrom(fieldType)) {
            return new Printer<Calendar>(){

                public String print(Calendar date, Locale locale) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.format(date.getTime());
                }
            };
        }
        throw new RuntimeException("Printer not found for type " + fieldType.getName());
    }

    public Parser<?> getParser(final DateFormatter annotation, Class<?> fieldType) {
        if (Date.class.isAssignableFrom(fieldType)) {
            return new Parser<Date>(){

                public Date parse(String text, Locale locale) throws ParseException {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    return dateFormat.parse(text);
                }
            };
        }
        if (Calendar.class.isAssignableFrom(fieldType)) {
            return new Parser<Calendar>(){

                public Calendar parse(String text, Locale locale) throws ParseException {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatterFactory.this.getLocalizedMessage(annotation.value(), locale), locale);
                    if (DateFormatterFactory.this.timezoneResolver != null) {
                        dateFormat.setTimeZone(DateFormatterFactory.this.timezoneResolver.getTimeZone());
                    }
                    Date date = dateFormat.parse(text);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    return calendar;
                }
            };
        }
        throw new RuntimeException("Parser not found for type " + fieldType.getName());
    }
}

