/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.streams;

import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;

public class EncryptedInputStream
extends InputStream {
    private InputStream inputStream;
    private Cipher cipher;
    private boolean closed = false;
    private byte[] buffer = new byte[0];
    private int bufferPos = 0;

    public EncryptedInputStream(InputStream inputStream, Cipher cipher) {
        this.inputStream = inputStream;
        this.cipher = cipher;
    }

    private synchronized void readData() throws IOException {
        int n1 = this.inputStream.read() & 0xFF;
        if (n1 < 0) {
            throw new IOException("End of stream reached");
        }
        int n2 = this.inputStream.read() << 8 & 0xFF;
        if (n2 < 0) {
            throw new IOException("End of stream reached");
        }
        int size = n1 + n2;
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            int n = this.inputStream.read();
            if (n < 0) {
                throw new IOException("End of stream reached");
            }
            data[i] = (byte)n;
        }
        this.bufferPos = 0;
        try {
            this.buffer = this.cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IOException("Error decrypting data", e);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        while (this.bufferPos == this.buffer.length) {
            this.readData();
        }
        return this.buffer[this.bufferPos++];
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inputStream.close();
    }
}

