/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.HashMap;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.AutomationSettings;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.fightinfo.FightInfo;
import si.nevensrok.jtekma.common.matchupload.NextMatchUpload;
import si.nevensrok.jtekma.common.system.Role;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dao.CompetitionDAO;
import si.nevensrok.jtekma.server.jobs.CompetitionAutomationJob;
import si.nevensrok.jtekma.server.management.CompetitionManager;

public class CompetitionManagerImpl
implements CompetitionManager {
    private static final Logger log = LoggerFactory.getLogger(CompetitionManagerImpl.class);
    private CompetitionDAO competitionDAO;
    private Scheduler scheduler;

    public void setCompetitionDAO(CompetitionDAO competitionDAO) {
        this.competitionDAO = competitionDAO;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition createCompetition(Competition competition) {
        if (log.isDebugEnabled()) {
            log.debug("Creating competition {}", (Object)competition);
        }
        return (Competition)this.competitionDAO.create((Pojo)competition);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition updateCompetition(Competition competition) {
        if (log.isDebugEnabled()) {
            log.debug("Updating competition {}", (Object)competition);
        }
        return (Competition)this.competitionDAO.update((Pojo)competition);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getById(Long competitionId) {
        return (Competition)this.competitionDAO.getById((Object)competitionId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Page<Competition> find(Page<Competition> page) {
        return this.competitionDAO.find(page, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Page<Competition> findForUser(User user, Page<Competition> page) {
        return this.competitionDAO.findForUser(user, page);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Role getCompetitionRoleForUser(User user, Competition competition) {
        return this.competitionDAO.getCompetitionRoleForUser(user, competition);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Competition, Role> getCompetitionRolesForUser(User user) {
        return this.competitionDAO.getCompetitionRolesForUser(user);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForCategory(Category category) {
        return this.competitionDAO.getCompetitionForCategory(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForClub(Club club) {
        return this.competitionDAO.getCompetitionForClub(club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForCompetitor(Competitor competitor) {
        return this.competitionDAO.getCompetitionForCompetitor(competitor);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForTatami(Tatami tatami) {
        return this.competitionDAO.getCompetitionForTatami(tatami);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForSemaphore(Semaphore semaphore) {
        return this.competitionDAO.getCompetitionForSemaphore(semaphore);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForFightInfo(FightInfo fightInfo) {
        return this.competitionDAO.getCompetitionForFightInfo(fightInfo);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForNextMatchUpload(NextMatchUpload nextMatchUpload) {
        return this.competitionDAO.getCompetitionForNextMatchUpload(nextMatchUpload);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Competition getCompetitionForCategoryGroup(CategoryGroup categoryGroup) {
        return this.competitionDAO.getCompetitionForCategoryGroup(categoryGroup);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<String, Object> getCompetitionSettings(Competition competition) {
        return this.competitionDAO.getCompetitionSettings(competition);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setCompetitionSettings(Competition competition, Map<String, Object> settings, boolean removeOther) {
        this.competitionDAO.setCompetitionSettings(competition, settings, removeOther);
    }

    @Transactional(value="jtekmaTransactionManager")
    public AutomationSettings getAutomationSettings(Competition competition) {
        AutomationSettings automationSettings = new AutomationSettings();
        Map<String, Object> settings = this.getCompetitionSettings(competition);
        if (settings.get("automation.active") != null) {
            automationSettings.setActive((Boolean)settings.get("automation.active"));
        } else {
            automationSettings.setActive(Boolean.FALSE);
        }
        if (settings.get("automation.calculateForMatchesInAdvance") != null) {
            automationSettings.setCalculateForMatchesInAdvance(Integer.valueOf(((Long)settings.get("automation.calculateForMatchesInAdvance")).intValue()));
        }
        if (settings.get("automation.minimumMatchDifferenceForCompetitor") != null) {
            automationSettings.setMinimumMatchDifferenceForCompetitor(Integer.valueOf(((Long)settings.get("automation.minimumMatchDifferenceForCompetitor")).intValue()));
        }
        if (settings.get("automation.calculationInterval") != null) {
            automationSettings.setCalculationInterval(AutomationSettings.CalculationInterval.valueOf((String)((String)settings.get("automation.calculationInterval"))));
        }
        return automationSettings;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setAutomationSettings(Competition competition, AutomationSettings automationSettings) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("automation.active", automationSettings.getActive());
        settings.put("automation.calculateForMatchesInAdvance", automationSettings.getCalculateForMatchesInAdvance());
        settings.put("automation.minimumMatchDifferenceForCompetitor", automationSettings.getMinimumMatchDifferenceForCompetitor());
        settings.put("automation.calculationInterval", automationSettings.getCalculationInterval().name());
        this.setCompetitionSettings(competition, settings, false);
        TriggerKey triggerKey = new TriggerKey("automation_" + competition.getCompetitionId(), "competitionAutomation");
        if (automationSettings.getActive() == null || !automationSettings.getActive().booleanValue()) {
            try {
                if (this.scheduler.checkExists(triggerKey)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unscheduling automation job for comeptition [{}]", (Object)competition);
                    }
                    this.scheduler.unscheduleJob(triggerKey);
                }
            }
            catch (Exception e) {
                log.error("Error unscheduling automation job for competition [" + competition.getCompetitionId() + "]", (Throwable)e);
            }
        } else {
            String cronExpresion = "0 0/1 * * * ?";
            if (automationSettings.getCalculationInterval() == AutomationSettings.CalculationInterval.HALFMINUTE) {
                cronExpresion = "0/30 * * * * ?";
            } else if (automationSettings.getCalculationInterval() == AutomationSettings.CalculationInterval.ONEMINUTE) {
                cronExpresion = "0 0/1 * * * ?";
            } else if (automationSettings.getCalculationInterval() == AutomationSettings.CalculationInterval.FIVEMINUTES) {
                cronExpresion = "0 0/5 * * * ?";
            } else if (automationSettings.getCalculationInterval() == AutomationSettings.CalculationInterval.TENMINUTES) {
                cronExpresion = "0 0/10 * * * ?";
            }
            try {
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpresion)).withPriority(3).build();
                if (this.scheduler.checkExists(triggerKey)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Rescheduling automation job for comeptition [{}]", (Object)competition);
                    }
                    this.scheduler.rescheduleJob(triggerKey, trigger);
                } else {
                    JobKey jobKey = new JobKey(triggerKey.getName(), triggerKey.getGroup());
                    JobDataMap jobDataMap = new JobDataMap();
                    jobDataMap.put("competitionId", (Object)competition.getCompetitionId());
                    JobDetail jobDetail = JobBuilder.newJob(CompetitionAutomationJob.class).withIdentity(jobKey).usingJobData(jobDataMap).build();
                    if (log.isDebugEnabled()) {
                        log.debug("Scheduling automation job for comeptition [{}]", (Object)competition);
                    }
                    this.scheduler.scheduleJob(jobDetail, trigger);
                }
            }
            catch (Exception e) {
                log.error("Error scheduling automation job for competition [" + competition.getCompetitionId() + "]", (Throwable)e);
            }
        }
    }
}

