/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.jobs;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.server.management.CompetitionImportManager;

public class CompetitionImportCleanupJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(CompetitionImportCleanupJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            log.debug("Competition import cleanup job started");
            ApplicationContext applicationContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
            if (applicationContext == null) {
                throw new RuntimeException("ApplicationContext not found");
            }
            CompetitionImportManager competitionImportManager = (CompetitionImportManager)applicationContext.getBean("jtekmaCompetitionImportManager");
            if (competitionImportManager == null) {
                throw new RuntimeException("CompetitionImportManager not found");
            }
            competitionImportManager.cleanupJobs();
            log.debug("Competition import cleanup job finished");
        }
        catch (Exception e) {
            log.error("Error executing competition import cleanup job", (Throwable)e);
        }
    }
}

