/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.ClubManager;

public class ClubImporter {
    private static final int bufferSize = 65536;
    private ClubManager clubManager;

    public void setClubManager(ClubManager clubManager) {
        this.clubManager = clubManager;
    }

    public List<Club> parseClubs(FileType fileType, byte[] fileData) throws Exception {
        LinkedList<Club> clubs = new LinkedList<Club>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int clubNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime kluba", "Klub", "Club", "Club name"});
        int clubShortNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Kratica", "Club Short Name", "Short Name"});
        if (clubNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoClubName);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String name = fileLine.getData(clubNameIndex);
            String shortName = fileLine.getData(clubShortNameIndex);
            if (name == null || name.trim().isEmpty()) continue;
            name = name.trim();
            if (shortName == null || shortName.trim().isEmpty()) {
                shortName = name;
            }
            shortName = shortName.trim();
            Club club = new Club();
            club.setName(name);
            club.setShortName(shortName);
            club.setStatus(Club.Status.ACTIVE);
            club.setCountForClubPlacings(Boolean.TRUE);
            clubs.add(club);
        }
        return clubs;
    }

    public void importClubs(Competition competition, List<Club> clubs) {
        for (Club club : clubs) {
            club.setCompetition(competition);
            if (this.clubManager.getActiveClubByName(competition, club.getName()) != null) continue;
            this.clubManager.createClub(club);
        }
    }

    public byte[] exportClubs(FileType fileType, List<Club> clubs, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        String[][] fileContent = new String[clubs.size() + 1][];
        fileContent[0] = header;
        int i = 1;
        for (Club club : clubs) {
            fileContent[i] = new String[]{club.getName(), club.getShortName()};
            ++i;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, fileContent);
        return buffer.toByteArray();
    }
}

