/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.remoting.jms.ServiceData;
import si.nevensrok.common.remoting.jms.ServiceExporter;

public class ServiceRepository
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ServiceRepository.class);
    private ConnectionFactory connectionFactory;
    private String serviceInfoTopic;
    private int responseTimeout = 30000;
    private List<ServiceExporter> serviceExporters;
    private Connection connection;
    private Session session;
    private Destination serviceInfoDestination;
    private MessageProducer serviceInfoProducer;
    private MessageConsumer serviceInfoMessageConsumer;
    private MessageProducer serviceInfoReplyProducer;
    private TemporaryQueue responseDestination;
    private MessageConsumer responseConsumer;
    private List<ServiceData> serviceDatas;
    private Map<String, Message> messages = new HashMap<String, Message>();

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setServiceInfoTopic(String serviceInfoTopic) {
        this.serviceInfoTopic = serviceInfoTopic;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setServiceExporters(List<ServiceExporter> serviceExporters) {
        this.serviceExporters = serviceExporters;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        if (this.serviceInfoTopic == null) {
            throw new IllegalArgumentException("Property 'serviceInfoTopic' is required");
        }
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.responseDestination = this.session.createTemporaryQueue();
        this.serviceInfoDestination = this.session.createTopic(this.serviceInfoTopic);
        this.serviceInfoProducer = this.session.createProducer(this.serviceInfoDestination);
        this.serviceInfoProducer.setDeliveryMode(1);
        this.serviceInfoProducer.setPriority(1);
        this.serviceInfoProducer.setTimeToLive((long)this.responseTimeout);
        this.responseConsumer = this.session.createConsumer((Destination)this.responseDestination);
        this.responseConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                log.trace("Service info response received: {}", (Object)message);
                ServiceRepository.this.processServiceInfoResponse(message);
            }
        });
        if (this.serviceExporters != null && !this.serviceExporters.isEmpty()) {
            this.serviceInfoReplyProducer = this.session.createProducer(null);
            this.serviceInfoReplyProducer.setDeliveryMode(1);
            this.serviceInfoReplyProducer.setPriority(1);
            this.serviceInfoReplyProducer.setTimeToLive((long)this.responseTimeout);
            this.serviceDatas = new LinkedList<ServiceData>();
            for (ServiceExporter serviceExporter : this.serviceExporters) {
                this.serviceDatas.add(new ServiceData(serviceExporter.getInterfaceClass(), serviceExporter.getVersion(), serviceExporter.getQueue()));
            }
            this.serviceInfoMessageConsumer = this.session.createConsumer(this.serviceInfoDestination);
            this.serviceInfoMessageConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    log.trace("Service info request received: {}", (Object)message);
                    ServiceRepository.this.processServiceInfoReqeust(message);
                }
            });
        }
    }

    public void destroy() throws Exception {
        try {
            this.serviceInfoReplyProducer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.serviceInfoMessageConsumer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.responseConsumer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.responseDestination.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.serviceInfoProducer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ServiceData findService(String className, String version) {
        String correlationId = null;
        try {
            ServiceData serviceData = new ServiceData(className, version, null);
            log.trace("Service data search filder: {}", (Object)serviceData);
            ObjectMessage message = this.session.createObjectMessage((Serializable)serviceData);
            message.setJMSReplyTo((Destination)this.responseDestination);
            correlationId = this.generateId();
            message.setJMSCorrelationID(correlationId);
            this.serviceInfoProducer.send((Message)message);
            ObjectMessage responseMessage = (ObjectMessage)this.getMessage(correlationId);
            log.trace("Response message: {}", (Object)responseMessage);
            ServiceData responseServiceData = (ServiceData)responseMessage.getObject();
            log.trace("Response service data: {}", (Object)responseServiceData);
            return responseServiceData;
        }
        catch (Exception e) {
            this.clearMessageId(correlationId);
            log.error("Error searching for service", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateId() {
        for (int i = 0; i < 1000; ++i) {
            String correlationId = UUID.randomUUID().toString();
            Map<String, Message> map = this.messages;
            synchronized (map) {
                if (!this.messages.containsKey(correlationId)) {
                    this.messages.put(correlationId, null);
                    return correlationId;
                }
                continue;
            }
        }
        throw new RuntimeException("Error while generating CorrelationId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMessageId(String correlationId) {
        Map<String, Message> map = this.messages;
        synchronized (map) {
            this.messages.remove(correlationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processServiceInfoResponse(Message message) {
        try {
            String correlationId = message.getJMSCorrelationID();
            if (correlationId == null || correlationId.isEmpty()) {
                throw new RuntimeException("CorrelationId not present");
            }
            Map<String, Message> map = this.messages;
            synchronized (map) {
                if (this.messages.containsKey(correlationId)) {
                    this.messages.put(correlationId, message);
                    this.messages.notifyAll();
                    return;
                }
            }
        }
        catch (Exception e) {
            log.error("Error procesing service info response", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message getMessage(String correlationId) {
        if (this.responseTimeout <= 0) {
            Map<String, Message> map = this.messages;
            synchronized (map) {
            }
        } else {
            long waitUntil = System.currentTimeMillis() + (long)this.responseTimeout;
            Map<String, Message> map = this.messages;
            synchronized (map) {
                while (true) {
                    if (this.messages.get(correlationId) != null) {
                        return this.messages.remove(correlationId);
                    }
                    if (!this.messages.containsKey(correlationId)) {
                        throw new RuntimeException("Reqeust message was cleared");
                    }
                    long waitTime = waitUntil - System.currentTimeMillis();
                    if (waitTime <= 0L) {
                        throw new RuntimeException("Response timeout expired");
                    }
                    try {
                        this.messages.wait(waitTime);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        {
            while (this.messages.get(correlationId) == null) {
                if (!this.messages.containsKey(correlationId)) {
                    throw new RuntimeException("Reqeust message was cleared");
                }
                try {
                    this.messages.wait();
                }
                catch (Exception exception) {
                }
            }
            return this.messages.remove(correlationId);
        }
    }

    private void processServiceInfoReqeust(Message message) {
        try {
            ObjectMessage objectMessage = (ObjectMessage)message;
            String correlationId = message.getJMSCorrelationID();
            log.trace("CorrelationId: [{}]", (Object)correlationId);
            if (correlationId == null || correlationId.isEmpty()) {
                throw new RuntimeException("CorrelationId not present");
            }
            ServiceData lookingForServiceData = (ServiceData)objectMessage.getObject();
            log.trace("Looking for service data: {}", (Object)lookingForServiceData);
            for (ServiceData serviceData : this.serviceDatas) {
                if (!lookingForServiceData.getClassName().equals(serviceData.getClassName()) || !lookingForServiceData.getVersion().equals(serviceData.getVersion())) continue;
                ObjectMessage responseMessage = this.session.createObjectMessage((Serializable)serviceData);
                responseMessage.setJMSCorrelationID(correlationId);
                log.trace("Sending service info response message: {}", (Object)responseMessage);
                this.serviceInfoReplyProducer.send(message.getJMSReplyTo(), (Message)responseMessage);
                break;
            }
        }
        catch (Exception e) {
            log.trace("Error processing message", (Throwable)e);
        }
    }
}

