/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.tools;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.server.tools.MatchNumberTool;
import si.nevensrok.jtekma.server.web.common.UserData;

public class MatchTool
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private UserData userData;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public String getLanguageText(Locale locale, String key) {
        return this.applicationContext.getMessage(key, null, key, locale);
    }

    public String getMatchName(Locale locale, TreeCategory treeCategory, Match match) {
        int matchNumber = match.getFightNumber();
        String matchName = this.getLanguageText(locale, "match.matchNum") + " " + String.valueOf(matchNumber);
        if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
            return matchName;
        }
        if (matchNumber >= 1 && matchNumber <= 32) {
            matchName = this.getLanguageText(locale, "match.text.tirtytwoFinals");
        } else if (matchNumber >= 33 && matchNumber <= 48) {
            matchName = this.getLanguageText(locale, "match.text.sixtinFinals");
        } else if (matchNumber >= 49 && matchNumber <= 64) {
            matchName = this.getLanguageText(locale, "match.text.repesagueSixtinFinalsPre");
        } else if (matchNumber >= 65 && matchNumber <= 80) {
            matchName = this.getLanguageText(locale, "match.text.repesagueSixtinFinals");
        } else if (matchNumber >= 81 && matchNumber <= 88) {
            matchName = this.getLanguageText(locale, "match.text.eightFinals");
        } else if (matchNumber >= 89 && matchNumber <= 96) {
            matchName = this.getLanguageText(locale, "match.text.repesagueEightFinalsPre");
        } else if (matchNumber >= 97 && matchNumber <= 104) {
            matchName = this.getLanguageText(locale, "match.text.repesagueEightFinals");
        } else if (matchNumber >= 105 && matchNumber <= 108) {
            matchName = this.getLanguageText(locale, "match.text.quaterFinals");
        } else if (matchNumber >= 109 && matchNumber <= 112) {
            matchName = this.getLanguageText(locale, "match.text.repesagueQuaterFinalsPre");
        } else if (matchNumber >= 113 && matchNumber <= 116) {
            matchName = this.getLanguageText(locale, "match.text.repesagueQuaterFinals");
        } else if (matchNumber >= 117 && matchNumber <= 118) {
            matchName = this.getLanguageText(locale, "match.text.halfFinals");
        } else if (matchNumber >= 119 && matchNumber <= 120) {
            matchName = treeCategory.getDouble3rdPlace().booleanValue() ? this.getLanguageText(locale, "match.text.repesagueHalfFinals") : this.getLanguageText(locale, "match.text.repesagueHalfFinalsPre");
        } else if (matchNumber >= 121 && matchNumber <= 122) {
            matchName = treeCategory.getDouble3rdPlace().booleanValue() ? this.getLanguageText(locale, "match.text.for3rdplace") : this.getLanguageText(locale, "match.text.repesagueHalfFinals");
        } else if (matchNumber == 123) {
            matchName = this.getLanguageText(locale, "match.text.for3rdplace");
        } else if (matchNumber == 124) {
            matchName = this.getLanguageText(locale, "match.text.finale");
        }
        return matchName;
    }

    public String getMatchShortName(TreeCategory treeCategory, Match match) {
        return String.valueOf(MatchNumberTool.getTransformedMatchNumber((TreeCategory.TreeType)treeCategory.getTreeType(), (boolean)treeCategory.getDouble3rdPlace(), (int)match.getFightNumber()));
    }
}

