/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.tools;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.common.dl.query.SimplePage;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.ManagersList;

public class DataInitializator
implements ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(DataInitializator.class);
    private boolean dataInitialized = false;
    private ManagersList managersList;

    public void setManagersList(ManagersList managersList) {
        this.managersList = managersList;
    }

    public synchronized void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            if (this.dataInitialized) {
                return;
            }
            this.dataInitialized = true;
            Thread initDataThread = new Thread("Data initializator thread"){

                @Override
                public void run() {
                    log.info("Initializing initial data");
                    try {
                        DataInitializator.this.initData();
                        log.info("Data initialization finished");
                    }
                    catch (Exception e) {
                        log.error("Error while data initialization", (Throwable)e);
                    }
                }
            };
            initDataThread.setDaemon(true);
            initDataThread.start();
        }
    }

    private void initData() {
        this.initAdminUser();
        this.initTreeAdvancments();
        this.initAgeCategories();
    }

    private void initAdminUser() {
        try {
            User user = this.managersList.getUserManager().getUserByUsername("admin");
            if (user == null) {
                log.debug("Creating admin user");
                user = new User();
                user.setUsername("admin");
                user.setPassword("admin");
                user.setName("Admin");
                user.setStatus(User.Status.ACTIVE);
                user.setEmail("admin@localhost");
                user.setIsSuperAdmin(Boolean.TRUE);
                this.managersList.getUserManager().createUser(user);
            }
        }
        catch (Exception e) {
            log.error("Error initializing admin user", (Throwable)e);
        }
    }

    private void initTreeAdvancments() {
        try {
            TreeAdvancment example = new TreeAdvancment();
            example.setStatus(TreeAdvancment.Status.ACTIVE);
            SimplePage page = new SimplePage((Object)example);
            page.setFetchList(false);
            page = this.managersList.getTreeAdvancmentManager().find((Page)page);
            if (page.getTotalRowCount() == 0L) {
                log.debug("Creating tree advancments");
                TreeAdvancment treeAdvancment = new TreeAdvancment();
                treeAdvancment.setName("Default");
                treeAdvancment.setStatus(TreeAdvancment.Status.ACTIVE);
                HashSet<TreeAdvancmentItem> treeAdvancmentItems = new HashSet<TreeAdvancmentItem>();
                treeAdvancment.setTreeAdvancmentItems(treeAdvancmentItems);
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(1), CompetitorType.COMPETITOR1, Integer.valueOf(2), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(1), CompetitorType.COMPETITOR2, Integer.valueOf(5), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(2), CompetitorType.COMPETITOR1, Integer.valueOf(3), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(2), CompetitorType.COMPETITOR2, Integer.valueOf(4), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(3), CompetitorType.COMPETITOR1, Integer.valueOf(3), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(3), CompetitorType.COMPETITOR2, Integer.valueOf(5), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(4), CompetitorType.COMPETITOR1, Integer.valueOf(1), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(4), CompetitorType.COMPETITOR2, Integer.valueOf(2), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(5), CompetitorType.COMPETITOR1, Integer.valueOf(1), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(5), CompetitorType.COMPETITOR2, Integer.valueOf(3), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(6), CompetitorType.COMPETITOR1, Integer.valueOf(4), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(6), CompetitorType.COMPETITOR2, Integer.valueOf(5), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(7), CompetitorType.COMPETITOR1, Integer.valueOf(1), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(7), CompetitorType.COMPETITOR2, Integer.valueOf(4), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(8), CompetitorType.COMPETITOR1, Integer.valueOf(2), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(8), CompetitorType.COMPETITOR2, Integer.valueOf(3), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(9), CompetitorType.COMPETITOR1, Integer.valueOf(2), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(9), CompetitorType.COMPETITOR2, Integer.valueOf(4), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(10), CompetitorType.COMPETITOR1, Integer.valueOf(1), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(10), CompetitorType.COMPETITOR2, Integer.valueOf(5), SelectType.DRAW, TreeType.TABLE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(1), CompetitorType.COMPETITOR1, Integer.valueOf(1), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(1), CompetitorType.COMPETITOR2, Integer.valueOf(33), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(2), CompetitorType.COMPETITOR1, Integer.valueOf(17), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(2), CompetitorType.COMPETITOR2, Integer.valueOf(49), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(3), CompetitorType.COMPETITOR1, Integer.valueOf(9), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(3), CompetitorType.COMPETITOR2, Integer.valueOf(41), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(4), CompetitorType.COMPETITOR1, Integer.valueOf(25), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(4), CompetitorType.COMPETITOR2, Integer.valueOf(57), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(5), CompetitorType.COMPETITOR1, Integer.valueOf(5), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(5), CompetitorType.COMPETITOR2, Integer.valueOf(37), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(6), CompetitorType.COMPETITOR1, Integer.valueOf(21), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(6), CompetitorType.COMPETITOR2, Integer.valueOf(53), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(7), CompetitorType.COMPETITOR1, Integer.valueOf(13), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(7), CompetitorType.COMPETITOR2, Integer.valueOf(45), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(8), CompetitorType.COMPETITOR1, Integer.valueOf(29), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(8), CompetitorType.COMPETITOR2, Integer.valueOf(61), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(9), CompetitorType.COMPETITOR1, Integer.valueOf(3), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(9), CompetitorType.COMPETITOR2, Integer.valueOf(35), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(10), CompetitorType.COMPETITOR1, Integer.valueOf(19), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(10), CompetitorType.COMPETITOR2, Integer.valueOf(51), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(11), CompetitorType.COMPETITOR1, Integer.valueOf(11), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(11), CompetitorType.COMPETITOR2, Integer.valueOf(43), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(12), CompetitorType.COMPETITOR1, Integer.valueOf(27), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(12), CompetitorType.COMPETITOR2, Integer.valueOf(59), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(13), CompetitorType.COMPETITOR1, Integer.valueOf(7), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(13), CompetitorType.COMPETITOR2, Integer.valueOf(39), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(14), CompetitorType.COMPETITOR1, Integer.valueOf(23), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(14), CompetitorType.COMPETITOR2, Integer.valueOf(55), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(15), CompetitorType.COMPETITOR1, Integer.valueOf(15), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(15), CompetitorType.COMPETITOR2, Integer.valueOf(47), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(16), CompetitorType.COMPETITOR1, Integer.valueOf(31), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(16), CompetitorType.COMPETITOR2, Integer.valueOf(63), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(17), CompetitorType.COMPETITOR1, Integer.valueOf(2), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(17), CompetitorType.COMPETITOR2, Integer.valueOf(34), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(18), CompetitorType.COMPETITOR1, Integer.valueOf(18), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(18), CompetitorType.COMPETITOR2, Integer.valueOf(50), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(19), CompetitorType.COMPETITOR1, Integer.valueOf(10), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(19), CompetitorType.COMPETITOR2, Integer.valueOf(42), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(20), CompetitorType.COMPETITOR1, Integer.valueOf(26), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(20), CompetitorType.COMPETITOR2, Integer.valueOf(58), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(21), CompetitorType.COMPETITOR1, Integer.valueOf(6), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(21), CompetitorType.COMPETITOR2, Integer.valueOf(38), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(22), CompetitorType.COMPETITOR1, Integer.valueOf(22), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(22), CompetitorType.COMPETITOR2, Integer.valueOf(54), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(23), CompetitorType.COMPETITOR1, Integer.valueOf(14), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(23), CompetitorType.COMPETITOR2, Integer.valueOf(46), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(24), CompetitorType.COMPETITOR1, Integer.valueOf(30), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(24), CompetitorType.COMPETITOR2, Integer.valueOf(62), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(25), CompetitorType.COMPETITOR1, Integer.valueOf(4), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(25), CompetitorType.COMPETITOR2, Integer.valueOf(36), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(26), CompetitorType.COMPETITOR1, Integer.valueOf(20), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(26), CompetitorType.COMPETITOR2, Integer.valueOf(52), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(27), CompetitorType.COMPETITOR1, Integer.valueOf(12), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(27), CompetitorType.COMPETITOR2, Integer.valueOf(44), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(28), CompetitorType.COMPETITOR1, Integer.valueOf(28), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(28), CompetitorType.COMPETITOR2, Integer.valueOf(60), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(29), CompetitorType.COMPETITOR1, Integer.valueOf(8), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(29), CompetitorType.COMPETITOR2, Integer.valueOf(40), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(30), CompetitorType.COMPETITOR1, Integer.valueOf(24), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(30), CompetitorType.COMPETITOR2, Integer.valueOf(56), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(31), CompetitorType.COMPETITOR1, Integer.valueOf(16), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(31), CompetitorType.COMPETITOR2, Integer.valueOf(48), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(32), CompetitorType.COMPETITOR1, Integer.valueOf(32), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(32), CompetitorType.COMPETITOR2, Integer.valueOf(64), SelectType.DRAW, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(33), CompetitorType.COMPETITOR1, Integer.valueOf(1), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(33), CompetitorType.COMPETITOR2, Integer.valueOf(2), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(34), CompetitorType.COMPETITOR1, Integer.valueOf(3), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(34), CompetitorType.COMPETITOR2, Integer.valueOf(4), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(35), CompetitorType.COMPETITOR1, Integer.valueOf(5), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(35), CompetitorType.COMPETITOR2, Integer.valueOf(6), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(36), CompetitorType.COMPETITOR1, Integer.valueOf(7), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(36), CompetitorType.COMPETITOR2, Integer.valueOf(8), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(37), CompetitorType.COMPETITOR1, Integer.valueOf(9), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(37), CompetitorType.COMPETITOR2, Integer.valueOf(10), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(38), CompetitorType.COMPETITOR1, Integer.valueOf(11), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(38), CompetitorType.COMPETITOR2, Integer.valueOf(12), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(39), CompetitorType.COMPETITOR1, Integer.valueOf(13), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(39), CompetitorType.COMPETITOR2, Integer.valueOf(14), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(40), CompetitorType.COMPETITOR1, Integer.valueOf(15), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(40), CompetitorType.COMPETITOR2, Integer.valueOf(16), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(41), CompetitorType.COMPETITOR1, Integer.valueOf(17), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(41), CompetitorType.COMPETITOR2, Integer.valueOf(18), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(42), CompetitorType.COMPETITOR1, Integer.valueOf(19), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(42), CompetitorType.COMPETITOR2, Integer.valueOf(20), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(43), CompetitorType.COMPETITOR1, Integer.valueOf(21), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(43), CompetitorType.COMPETITOR2, Integer.valueOf(22), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(44), CompetitorType.COMPETITOR1, Integer.valueOf(23), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(44), CompetitorType.COMPETITOR2, Integer.valueOf(24), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(45), CompetitorType.COMPETITOR1, Integer.valueOf(25), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(45), CompetitorType.COMPETITOR2, Integer.valueOf(26), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(46), CompetitorType.COMPETITOR1, Integer.valueOf(27), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(46), CompetitorType.COMPETITOR2, Integer.valueOf(28), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(47), CompetitorType.COMPETITOR1, Integer.valueOf(29), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(47), CompetitorType.COMPETITOR2, Integer.valueOf(30), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(48), CompetitorType.COMPETITOR1, Integer.valueOf(31), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(48), CompetitorType.COMPETITOR2, Integer.valueOf(32), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(49), CompetitorType.COMPETITOR1, Integer.valueOf(1), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(49), CompetitorType.COMPETITOR2, Integer.valueOf(2), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(50), CompetitorType.COMPETITOR1, Integer.valueOf(3), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(50), CompetitorType.COMPETITOR2, Integer.valueOf(4), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(51), CompetitorType.COMPETITOR1, Integer.valueOf(5), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(51), CompetitorType.COMPETITOR2, Integer.valueOf(6), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(52), CompetitorType.COMPETITOR1, Integer.valueOf(7), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(52), CompetitorType.COMPETITOR2, Integer.valueOf(8), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(53), CompetitorType.COMPETITOR1, Integer.valueOf(9), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(53), CompetitorType.COMPETITOR2, Integer.valueOf(10), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(54), CompetitorType.COMPETITOR1, Integer.valueOf(11), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(54), CompetitorType.COMPETITOR2, Integer.valueOf(12), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(55), CompetitorType.COMPETITOR1, Integer.valueOf(13), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(55), CompetitorType.COMPETITOR2, Integer.valueOf(14), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(56), CompetitorType.COMPETITOR1, Integer.valueOf(15), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(56), CompetitorType.COMPETITOR2, Integer.valueOf(16), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(57), CompetitorType.COMPETITOR1, Integer.valueOf(17), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(57), CompetitorType.COMPETITOR2, Integer.valueOf(18), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(58), CompetitorType.COMPETITOR1, Integer.valueOf(19), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(58), CompetitorType.COMPETITOR2, Integer.valueOf(20), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(59), CompetitorType.COMPETITOR1, Integer.valueOf(21), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(59), CompetitorType.COMPETITOR2, Integer.valueOf(22), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(60), CompetitorType.COMPETITOR1, Integer.valueOf(23), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(60), CompetitorType.COMPETITOR2, Integer.valueOf(24), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(61), CompetitorType.COMPETITOR1, Integer.valueOf(25), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(61), CompetitorType.COMPETITOR2, Integer.valueOf(26), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(62), CompetitorType.COMPETITOR1, Integer.valueOf(27), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(62), CompetitorType.COMPETITOR2, Integer.valueOf(28), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(63), CompetitorType.COMPETITOR1, Integer.valueOf(29), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(63), CompetitorType.COMPETITOR2, Integer.valueOf(30), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(64), CompetitorType.COMPETITOR1, Integer.valueOf(31), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(64), CompetitorType.COMPETITOR2, Integer.valueOf(32), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(65), CompetitorType.COMPETITOR1, Integer.valueOf(49), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(65), CompetitorType.COMPETITOR2, Integer.valueOf(41), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(66), CompetitorType.COMPETITOR1, Integer.valueOf(50), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(66), CompetitorType.COMPETITOR2, Integer.valueOf(42), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(67), CompetitorType.COMPETITOR1, Integer.valueOf(51), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(67), CompetitorType.COMPETITOR2, Integer.valueOf(43), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(68), CompetitorType.COMPETITOR1, Integer.valueOf(52), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(68), CompetitorType.COMPETITOR2, Integer.valueOf(44), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(69), CompetitorType.COMPETITOR1, Integer.valueOf(53), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(69), CompetitorType.COMPETITOR2, Integer.valueOf(45), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(70), CompetitorType.COMPETITOR1, Integer.valueOf(54), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(70), CompetitorType.COMPETITOR2, Integer.valueOf(46), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(71), CompetitorType.COMPETITOR1, Integer.valueOf(55), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(71), CompetitorType.COMPETITOR2, Integer.valueOf(47), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(72), CompetitorType.COMPETITOR1, Integer.valueOf(56), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(72), CompetitorType.COMPETITOR2, Integer.valueOf(48), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(73), CompetitorType.COMPETITOR1, Integer.valueOf(57), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(73), CompetitorType.COMPETITOR2, Integer.valueOf(33), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(74), CompetitorType.COMPETITOR1, Integer.valueOf(58), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(74), CompetitorType.COMPETITOR2, Integer.valueOf(34), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(75), CompetitorType.COMPETITOR1, Integer.valueOf(59), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(75), CompetitorType.COMPETITOR2, Integer.valueOf(35), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(76), CompetitorType.COMPETITOR1, Integer.valueOf(60), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(76), CompetitorType.COMPETITOR2, Integer.valueOf(36), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(77), CompetitorType.COMPETITOR1, Integer.valueOf(61), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(77), CompetitorType.COMPETITOR2, Integer.valueOf(37), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(78), CompetitorType.COMPETITOR1, Integer.valueOf(62), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(78), CompetitorType.COMPETITOR2, Integer.valueOf(38), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(79), CompetitorType.COMPETITOR1, Integer.valueOf(63), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(79), CompetitorType.COMPETITOR2, Integer.valueOf(39), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(80), CompetitorType.COMPETITOR1, Integer.valueOf(64), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(80), CompetitorType.COMPETITOR2, Integer.valueOf(40), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(81), CompetitorType.COMPETITOR1, Integer.valueOf(33), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(81), CompetitorType.COMPETITOR2, Integer.valueOf(34), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(82), CompetitorType.COMPETITOR1, Integer.valueOf(35), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(82), CompetitorType.COMPETITOR2, Integer.valueOf(36), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(83), CompetitorType.COMPETITOR1, Integer.valueOf(37), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(83), CompetitorType.COMPETITOR2, Integer.valueOf(38), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(84), CompetitorType.COMPETITOR1, Integer.valueOf(39), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(84), CompetitorType.COMPETITOR2, Integer.valueOf(40), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(85), CompetitorType.COMPETITOR1, Integer.valueOf(41), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(85), CompetitorType.COMPETITOR2, Integer.valueOf(42), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(86), CompetitorType.COMPETITOR1, Integer.valueOf(43), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(86), CompetitorType.COMPETITOR2, Integer.valueOf(44), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(87), CompetitorType.COMPETITOR1, Integer.valueOf(45), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(87), CompetitorType.COMPETITOR2, Integer.valueOf(46), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(88), CompetitorType.COMPETITOR1, Integer.valueOf(47), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(88), CompetitorType.COMPETITOR2, Integer.valueOf(48), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(89), CompetitorType.COMPETITOR1, Integer.valueOf(65), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(89), CompetitorType.COMPETITOR2, Integer.valueOf(66), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(90), CompetitorType.COMPETITOR1, Integer.valueOf(67), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(90), CompetitorType.COMPETITOR2, Integer.valueOf(68), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(91), CompetitorType.COMPETITOR1, Integer.valueOf(69), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(91), CompetitorType.COMPETITOR2, Integer.valueOf(70), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(92), CompetitorType.COMPETITOR1, Integer.valueOf(71), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(92), CompetitorType.COMPETITOR2, Integer.valueOf(72), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(93), CompetitorType.COMPETITOR1, Integer.valueOf(73), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(93), CompetitorType.COMPETITOR2, Integer.valueOf(74), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(94), CompetitorType.COMPETITOR1, Integer.valueOf(75), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(94), CompetitorType.COMPETITOR2, Integer.valueOf(76), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(95), CompetitorType.COMPETITOR1, Integer.valueOf(77), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(95), CompetitorType.COMPETITOR2, Integer.valueOf(78), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(96), CompetitorType.COMPETITOR1, Integer.valueOf(79), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(96), CompetitorType.COMPETITOR2, Integer.valueOf(80), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(97), CompetitorType.COMPETITOR1, Integer.valueOf(89), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(97), CompetitorType.COMPETITOR2, Integer.valueOf(86), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(98), CompetitorType.COMPETITOR1, Integer.valueOf(90), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(98), CompetitorType.COMPETITOR2, Integer.valueOf(85), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(99), CompetitorType.COMPETITOR1, Integer.valueOf(91), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(99), CompetitorType.COMPETITOR2, Integer.valueOf(88), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(100), CompetitorType.COMPETITOR1, Integer.valueOf(92), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(100), CompetitorType.COMPETITOR2, Integer.valueOf(87), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(101), CompetitorType.COMPETITOR1, Integer.valueOf(93), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(101), CompetitorType.COMPETITOR2, Integer.valueOf(82), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(102), CompetitorType.COMPETITOR1, Integer.valueOf(94), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(102), CompetitorType.COMPETITOR2, Integer.valueOf(81), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(103), CompetitorType.COMPETITOR1, Integer.valueOf(95), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(103), CompetitorType.COMPETITOR2, Integer.valueOf(84), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(104), CompetitorType.COMPETITOR1, Integer.valueOf(96), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(104), CompetitorType.COMPETITOR2, Integer.valueOf(83), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(105), CompetitorType.COMPETITOR1, Integer.valueOf(81), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(105), CompetitorType.COMPETITOR2, Integer.valueOf(82), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(106), CompetitorType.COMPETITOR1, Integer.valueOf(83), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(106), CompetitorType.COMPETITOR2, Integer.valueOf(84), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(107), CompetitorType.COMPETITOR1, Integer.valueOf(85), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(107), CompetitorType.COMPETITOR2, Integer.valueOf(86), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(108), CompetitorType.COMPETITOR1, Integer.valueOf(87), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(108), CompetitorType.COMPETITOR2, Integer.valueOf(88), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(109), CompetitorType.COMPETITOR1, Integer.valueOf(97), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(109), CompetitorType.COMPETITOR2, Integer.valueOf(98), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(110), CompetitorType.COMPETITOR1, Integer.valueOf(99), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(110), CompetitorType.COMPETITOR2, Integer.valueOf(100), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(111), CompetitorType.COMPETITOR1, Integer.valueOf(101), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(111), CompetitorType.COMPETITOR2, Integer.valueOf(102), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(112), CompetitorType.COMPETITOR1, Integer.valueOf(103), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(112), CompetitorType.COMPETITOR2, Integer.valueOf(104), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(113), CompetitorType.COMPETITOR1, Integer.valueOf(109), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(113), CompetitorType.COMPETITOR2, Integer.valueOf(106), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(114), CompetitorType.COMPETITOR1, Integer.valueOf(110), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(114), CompetitorType.COMPETITOR2, Integer.valueOf(105), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(115), CompetitorType.COMPETITOR1, Integer.valueOf(111), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(115), CompetitorType.COMPETITOR2, Integer.valueOf(108), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(116), CompetitorType.COMPETITOR1, Integer.valueOf(112), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(116), CompetitorType.COMPETITOR2, Integer.valueOf(107), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(117), CompetitorType.COMPETITOR1, Integer.valueOf(105), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(117), CompetitorType.COMPETITOR2, Integer.valueOf(106), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(118), CompetitorType.COMPETITOR1, Integer.valueOf(107), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(118), CompetitorType.COMPETITOR2, Integer.valueOf(108), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(119), CompetitorType.COMPETITOR1, Integer.valueOf(113), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(119), CompetitorType.COMPETITOR2, Integer.valueOf(114), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(120), CompetitorType.COMPETITOR1, Integer.valueOf(115), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(120), CompetitorType.COMPETITOR2, Integer.valueOf(116), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(121), CompetitorType.COMPETITOR1, Integer.valueOf(119), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(121), CompetitorType.COMPETITOR2, Integer.valueOf(118), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(122), CompetitorType.COMPETITOR1, Integer.valueOf(120), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(122), CompetitorType.COMPETITOR2, Integer.valueOf(117), SelectType.LOSER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(123), CompetitorType.COMPETITOR1, Integer.valueOf(121), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(123), CompetitorType.COMPETITOR2, Integer.valueOf(122), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(124), CompetitorType.COMPETITOR1, Integer.valueOf(117), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                treeAdvancmentItems.add(new TreeAdvancmentItem(null, Integer.valueOf(124), CompetitorType.COMPETITOR2, Integer.valueOf(118), SelectType.WINNER, TreeType.TREE, treeAdvancment));
                this.managersList.getTreeAdvancmentManager().createTreeAvancment(treeAdvancment);
            }
        }
        catch (Exception e) {
            log.error("Error initializing tree advancments", (Throwable)e);
        }
    }

    private void initAgeCategories() {
        try {
            if (!this.doesAgeCategoryExists("Seniors")) {
                log.debug("Creating age category 'Seniors'");
                this.createAgeCategory("Seniors", 22, 180, 15);
            }
            if (!this.doesAgeCategoryExists("Juniors")) {
                log.debug("Creating age category 'Juniors'");
                this.createAgeCategory("Juniors", 21, 180, 15);
            }
            if (!this.doesAgeCategoryExists("Aspirants")) {
                log.debug("Creating age category 'Aspirants'");
                this.createAgeCategory("Aspirants", 18, 180, 15);
            }
            if (!this.doesAgeCategoryExists("U15")) {
                log.debug("Creating age category 'U15'");
                this.createAgeCategory("U15", 15, 120, 15);
            }
            if (!this.doesAgeCategoryExists("U14")) {
                log.debug("Creating age category 'U14'");
                this.createAgeCategory("U14", 14, 120, 10);
            }
            if (!this.doesAgeCategoryExists("U12")) {
                log.debug("Creating age category 'U12'");
                this.createAgeCategory("U12", 12, 120, 10);
            }
            if (!this.doesAgeCategoryExists("U11")) {
                log.debug("Creating age category 'U11'");
                this.createAgeCategory("U11", 11, 120, 10);
            }
            if (!this.doesAgeCategoryExists("U10")) {
                log.debug("Creating age category 'U10'");
                this.createAgeCategory("U10", 10, 120, 10);
            }
            if (!this.doesAgeCategoryExists("U9")) {
                log.debug("Creating age category 'U9'");
                this.createAgeCategory("U9", 9, 90, 10);
            }
            if (!this.doesAgeCategoryExists("U8")) {
                log.debug("Creating age category 'U8'");
                this.createAgeCategory("U8", 8, 90, 10);
            }
            if (!this.doesAgeCategoryExists("CHILDREN")) {
                log.debug("Creating age category 'CHILDREN'");
                this.createAgeCategory("CHILDREN", 14, 120, 15);
            }
            if (!this.doesAgeCategoryExists("CHILDREN A")) {
                log.debug("Creating age category 'CHILDREN A'");
                this.createAgeCategory("CHILDREN A", 8, 90, 10);
            }
            if (!this.doesAgeCategoryExists("CHILDREN B")) {
                log.debug("Creating age category 'CHILDREN B'");
                this.createAgeCategory("CHILDREN B", 10, 120, 10);
            }
            if (!this.doesAgeCategoryExists("Newaza-Seniors")) {
                log.debug("Creating age category 'Newaza-Seniors'");
                this.createAgeCategory("Newaza-Seniors", 22, 360, 15);
            }
            if (!this.doesAgeCategoryExists("Newaza-Juniors")) {
                log.debug("Creating age category 'Newaza-Juniors'");
                this.createAgeCategory("Newaza-Juniors", 21, 300, 15);
            }
            if (!this.doesAgeCategoryExists("Newaza-Aspirants")) {
                log.debug("Creating age category 'Newaza-Aspirants'");
                this.createAgeCategory("Newaza-Aspirants", 18, 240, 15);
            }
            if (!this.doesAgeCategoryExists("Newaza-U15")) {
                log.debug("Creating age category 'Newaza-U15'");
                this.createAgeCategory("Newaza-U15", 15, 180, 15);
            }
        }
        catch (Exception e) {
            log.error("Error initializing age categories", (Throwable)e);
        }
    }

    private boolean doesAgeCategoryExists(String name) {
        AgeCategoryOption example = new AgeCategoryOption();
        example.setName(name);
        SimplePage page = new SimplePage((Object)example);
        page.setFetchList(false);
        page = this.managersList.getAgeCategoryOptionManager().find((Page)page);
        return page.getTotalRowCount() > 0L;
    }

    private AgeCategoryOption createAgeCategory(String name, Integer age, Integer fightTime, Integer hosekomiTime) {
        AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
        ageCategoryOption.setName(name);
        ageCategoryOption.setAge(age);
        ageCategoryOption.setStatus(AgeCategoryOption.Status.ACTIVE);
        ageCategoryOption.setFightTime(fightTime);
        ageCategoryOption.setHosekomiTime(hosekomiTime);
        return this.managersList.getAgeCategoryOptionManager().createAgeCategoryOption(ageCategoryOption);
    }
}

