/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.systemsettings;

import java.lang.constant.Constable;
import java.text.Normalizer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competition.CompetitionImport;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.systemsettings.CompetitionModel;
import si.nevensrok.jtekma.server.web.controllers.systemsettings.ImportCompetitionModel;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/system-settings/competitions"})
@SessionAttributes(value={"competitionListFilter"})
public class CompetitionsController
extends CoreController {
    private static final Logger log = LoggerFactory.getLogger(CompetitionsController.class);

    public Map<String, String> getStatuses(Locale locale) {
        LinkedHashMap<String, String> categoryTypes = new LinkedHashMap<String, String>();
        categoryTypes.put(Competition.Status.ACTIVE.name(), this.getLanguageText(locale, "competitions.status." + Competition.Status.ACTIVE.name()));
        categoryTypes.put(Competition.Status.FINISHED.name(), this.getLanguageText(locale, "competitions.status." + Competition.Status.FINISHED.name()));
        return categoryTypes;
    }

    public Map<String, String> getRules() {
        LinkedHashMap<String, String> rules = new LinkedHashMap<String, String>();
        for (String ruleName : this.getManagersList().getRulesManager().getAvailableCompetitionRules()) {
            rules.put(ruleName, ruleName);
        }
        return rules;
    }

    private void addFormOptions(Model model, Locale locale) {
        model.addAttribute("statuses", this.getStatuses(locale));
        model.addAttribute("rules", this.getRules());
    }

    @ModelAttribute(value="competitionsActive")
    public Boolean getCompetitionsActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="competitionListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="competitionListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        HashMap<Competition, CompetitionImport> importing = new HashMap<Competition, CompetitionImport>();
        Page page = new Page();
        page = this.getManagersList().getCompetitionImportManager().find(page);
        for (CompetitionImport competitionImport : page.getData()) {
            importing.put(competitionImport.getCompetition(), competitionImport);
        }
        model.addAttribute("importing", importing);
        Page filterPage = new Page();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        filterPage.setFilter((Filter)rootFilter);
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        GroupFilter statusFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)statusFilter);
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competition.Status.ACTIVE));
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Competition.Status.FINISHED));
        filterPage.setSort(new Sort());
        filterPage.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        Integer page2 = searchFilter.getPage();
        Integer showPerPage = searchFilter.getShowPerPage();
        filterPage.setStartIndex(Long.valueOf((page2.longValue() - 1L) * showPerPage.longValue()));
        filterPage.setPageRowLimitCount(Long.valueOf(showPerPage.longValue()));
        Page resultPage = this.getManagersList().getCompetitionManager().find(filterPage);
        model.addAttribute("competitions", (Object)resultPage.getData());
        Long totalPages = (long)Math.ceil((double)resultPage.getTotalRowCount().longValue() / showPerPage.doubleValue());
        if (totalPages < 1L) {
            totalPages = 1L;
        }
        model.addAttribute("totalPages", (Object)totalPages);
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "competitions.text.added"));
        } else if (messageCode == 2) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "competitions.text.updated"));
        } else if (messageCode == 3) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "competitions.text.deleted"));
        } else if (messageCode == 4) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "competitions.text.imported"));
        }
        return "system-settings/competition-list";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="competition") CompetitionModel competitionModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        if (!bindingResult.hasErrors()) {
            competitionModel.setName("");
            competitionModel.setCompetitonDate(Calendar.getInstance().getTime());
            competitionModel.setDescription("");
            competitionModel.setStatus(Competition.Status.ACTIVE);
            competitionModel.setRules((String)this.getManagersList().getRulesManager().getAvailableCompetitionRules().get(0));
        }
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/competition-edit";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="competition") @Valid CompetitionModel competitionModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.add(request, model, competitionModel, bindingResult);
        }
        Competition competition = new Competition();
        ObjectUtil.copyNotNullProperties((Object)competitionModel, (Object)competition);
        competition = this.getManagersList().getCompetitionManager().createCompetition(competition);
        HashMap<String, Constable> competitionSettings = new HashMap<String, Constable>();
        competitionSettings.put("clubPlacing.points.1", Integer.valueOf(10));
        competitionSettings.put("clubPlacing.points.2", Integer.valueOf(7));
        competitionSettings.put("clubPlacing.points.3", Integer.valueOf(5));
        competitionSettings.put("clubPlacing.points.4", Integer.valueOf(4));
        competitionSettings.put("clubPlacing.points.5", Integer.valueOf(3));
        competitionSettings.put("clubPlacing.points.6", Integer.valueOf(2));
        competitionSettings.put("clubPlacing.points.7", Integer.valueOf(1));
        competitionSettings.put("clubPlacing.includeOneCompetitor", Boolean.FALSE);
        competitionSettings.put("clubPlacing.includeSameClub", Boolean.FALSE);
        this.getManagersList().getCompetitionManager().setCompetitionSettings(competition, competitionSettings, false);
        return "redirect:/system-settings/competitions?messageCode=1";
    }

    @RequestMapping(value={"/edit/{competitionId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="competitionId") Long competitionId, @ModelAttribute(value="competition") CompetitionModel competitionModel, BindingResult bindingResult) {
        Competition competition = this.getManagersList().getCompetitionManager().getById(competitionId);
        ObjectUtil.copyNotNullProperties((Object)competition, (Object)competitionModel);
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/competition-edit";
    }

    @RequestMapping(value={"/edit/{competitionId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="competitionId") Long competitionId, @ModelAttribute(value="competition") @Valid CompetitionModel competitionModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, competitionId, competitionModel, bindingResult);
        }
        Competition competition = this.getManagersList().getCompetitionManager().getById(competitionId);
        ObjectUtil.copyNotNullProperties((Object)competitionModel, (Object)competition);
        competition = this.getManagersList().getCompetitionManager().updateCompetition(competition);
        return "redirect:/system-settings/competitions?messageCode=2";
    }

    @RequestMapping(value={"/delete/{competitionId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="competitionId") Long competitionId) {
        Competition competition = this.getManagersList().getCompetitionManager().getById(competitionId);
        competition.setStatus(Competition.Status.DELETED);
        competition = this.getManagersList().getCompetitionManager().updateCompetition(competition);
        return "redirect:/system-settings/competitions?messageCode=3";
    }

    @RequestMapping(value={"/export/{competitionId}"})
    public void export(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="competitionId") Long competitionId) {
        block4: {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("application/jtekma-competition");
            Competition competition = this.getManagersList().getCompetitionManager().getById(competitionId);
            byte[] data = this.getManagersList().getDataExportImportManager().exportCompetition(competition);
            String fileName = competition.getName() + ".jtm";
            fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            ServletOutputStream outputStream = null;
            try {
                outputStream = response.getOutputStream();
                outputStream.write(data);
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception e) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!log.isDebugEnabled()) break block4;
                log.debug("Error writeing competition export data", (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importCompetition(HttpServletRequest request, Model model, @ModelAttribute(value="importCompetition") ImportCompetitionModel importCompetitionModel, BindingResult bindingResult) {
        return "system-settings/competition-import";
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importCompetitionPost(HttpServletRequest request, Model model, @ModelAttribute(value="importCompetition") @Valid ImportCompetitionModel importCompetitionModel, BindingResult bindingResult) {
        if (importCompetitionModel.getFile() != null && importCompetitionModel.getFile().isEmpty()) {
            bindingResult.rejectValue("file", "common.error.fileNotSelected");
        }
        if (bindingResult.hasErrors()) {
            return this.importCompetition(request, model, importCompetitionModel, bindingResult);
        }
        try {
            byte[] data = importCompetitionModel.getFile().getBytes();
            this.getManagersList().getDataExportImportManager().importCompetition(data);
        }
        catch (Exception e) {
            log.error("Error importing competition", (Throwable)e);
        }
        return "redirect:/system-settings/competitions?messageCode=4";
    }
}

