/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.common.dl.query.SimplePage;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.reports.DocumentType;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.reports.PlacingsReportModel;

@Controller
@RequestMapping(value={"/reports/club-placings"})
public class ClubPlacingsReportController
extends CoreController {
    @RequestMapping(method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model, @ModelAttribute(value="placingsReport") PlacingsReportModel placingsReportModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        model.addAttribute("clubPlacingsActive", (Object)true);
        LinkedHashMap<String, String> documentTypes = new LinkedHashMap<String, String>();
        documentTypes.put(DocumentType.PDF.name(), this.getLanguageText(locale, "report.documentType.PDF"));
        documentTypes.put(DocumentType.ODT.name(), this.getLanguageText(locale, "report.documentType.ODT"));
        model.addAttribute("documentTypes", documentTypes);
        LinkedHashMap<String, String> locales = new LinkedHashMap<String, String>();
        locales.put("en", this.getLanguageText(locale, "locale.english"));
        locales.put("sl", this.getLanguageText(locale, "locale.slovenian"));
        model.addAttribute("locales", locales);
        placingsReportModel.setLocale(RequestContextUtils.getLocale((HttpServletRequest)request).getLanguage());
        Category categoryExample = new Category();
        categoryExample.setStatus(Category.Status.ACTIVE);
        SimplePage categoryFilterPage = new SimplePage((Object)categoryExample);
        categoryFilterPage.setSort(new Sort());
        categoryFilterPage.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        Page categoryResultPage = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (Page)categoryFilterPage);
        LinkedHashMap<Long, String> categories = new LinkedHashMap<Long, String>();
        for (Category category : categoryResultPage.getData()) {
            if (!category.getCountForClubPlacings().booleanValue() || !(category instanceof TreeCategory)) continue;
            categories.put(category.getCategoryId(), category.getName());
            placingsReportModel.getCategories().add(category.getCategoryId());
        }
        model.addAttribute("categories", categories);
        Page categoryGroupPage = new Page();
        categoryGroupPage.setSort(new Sort());
        categoryGroupPage.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        categoryGroupPage = this.getManagersList().getCategoryGroupManager().findCategoryGroups(this.getUserData().getCompetition(), categoryGroupPage);
        LinkedHashMap<Long, String> categoryGroups = new LinkedHashMap<Long, String>();
        categoryGroups.put(0L, "&nbsp;");
        for (CategoryGroup categoryGroup : categoryGroupPage.getData()) {
            categoryGroups.put(categoryGroup.getCategoryGroupId(), categoryGroup.getName());
        }
        model.addAttribute("categoryGroups", categoryGroups);
        return "reports/club-placings";
    }

    @RequestMapping(method={RequestMethod.POST})
    public void download(HttpServletRequest request, HttpServletResponse response, @ModelAttribute(value="placingsReport") PlacingsReportModel placingsReportModel) throws IOException {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String fileName = this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "report.filename.clubPlacings");
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        if (placingsReportModel.getDocumentType() == DocumentType.PDF) {
            response.setContentType("application/pdf");
            fileName = fileName + ".pdf";
        } else if (placingsReportModel.getDocumentType() == DocumentType.ODT) {
            response.setContentType("application/vnd.oasis.opendocument.text");
            fileName = fileName + ".odt";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        CategoryGroup categoryGroup = null;
        if (placingsReportModel.getForCategoryGroup() != null && placingsReportModel.getForCategoryGroup() > 0L) {
            categoryGroup = new CategoryGroup();
            categoryGroup.setCategoryGroupId(placingsReportModel.getForCategoryGroup());
        }
        LinkedList<Category> categories = new LinkedList<Category>();
        for (Long categoryId : placingsReportModel.getCategories()) {
            Category category = new Category();
            category.setCategoryId(categoryId);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId()) || categoryGroup != null && !this.getManagersList().getCategoryGroupManager().isInCategoryGroup(categoryGroup, category)) continue;
            categories.add(category);
        }
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        if (placingsReportModel.getLocale() != null) {
            locale = new Locale(placingsReportModel.getLocale());
        }
        ServletOutputStream outputStream = response.getOutputStream();
        this.getManagersList().getReportGenerator().generateClubPlacingsReport(placingsReportModel.getDocumentType(), locale, (OutputStream)outputStream, this.getUserData().getCompetition(), categories);
        outputStream.close();
    }
}

