/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.common.dl.query.SimplePage;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.fightinfo.FightInfo;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.web.common.ImportDataModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.FightInfoModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/fight-info"})
@SessionAttributes(value={"fightInfoListFilter"})
public class FightInfoController
extends CoreController {
    private static final Logger log = LoggerFactory.getLogger(FightInfoController.class);

    @ModelAttribute(value="fightInfoActive")
    public Boolean getFightInfoActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="fightInfoListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.FIGHTINFOEDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="fightInfoListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        FightInfo example = new FightInfo();
        example.setUsername("%" + searchFilter.getSearch().trim() + "%");
        SimplePage filterPage = new SimplePage((Object)example);
        filterPage.setSort(new Sort());
        filterPage.getSort().addField(new Sort.Field("username", Sort.Field.Direction.ASC, false));
        Integer page = searchFilter.getPage();
        Integer showPerPage = searchFilter.getShowPerPage();
        filterPage.setStartIndex(Long.valueOf((page.longValue() - 1L) * showPerPage.longValue()));
        filterPage.setPageRowLimitCount(Long.valueOf(showPerPage.longValue()));
        Page resultPage = this.getManagersList().getFightInfoManager().find(this.getUserData().getCompetition(), (Page)filterPage);
        model.addAttribute("fightInfos", (Object)resultPage.getData());
        Long totalPages = (long)Math.ceil((double)resultPage.getTotalRowCount().longValue() / showPerPage.doubleValue());
        if (totalPages < 1L) {
            totalPages = 1L;
        }
        model.addAttribute("totalPages", (Object)totalPages);
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "fightInfo.text.added"));
        } else if (messageCode == 2) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "fightInfo.text.updated"));
        } else if (messageCode == 3) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "fightInfo.text.deleted"));
        } else if (messageCode == 4) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "fightInfo.text.imported"));
        }
        return "data/fightinfo-list";
    }

    @MethodRight(value={Right.FIGHTINFOEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="fightInfo") FightInfoModel fightInfoModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        return "data/fightinfo-edit";
    }

    @MethodRight(value={Right.FIGHTINFOEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="fightInfo") @Valid FightInfoModel fightInfoModel, BindingResult bindingResult) {
        if (fightInfoModel.getPassword() == null || fightInfoModel.getPassword().isEmpty()) {
            bindingResult.rejectValue("password", "common.error.dataNotEntered");
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, fightInfoModel, bindingResult);
        }
        FightInfo fightInfo = new FightInfo();
        ObjectUtil.copyNotNullProperties((Object)fightInfoModel, (Object)fightInfo);
        fightInfo.setCompetition(this.getUserData().getCompetition());
        fightInfo = this.getManagersList().getFightInfoManager().createFightInfo(fightInfo);
        return "redirect:/data/fight-info?messageCode=1";
    }

    @MethodRight(value={Right.FIGHTINFOEDIT})
    @RequestMapping(value={"/edit/{fightInfoId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="fightInfoId") Long fightInfoId, @ModelAttribute(value="fightInfo") FightInfoModel fightInfoModel, BindingResult bindingResult) {
        FightInfo fightInfo = this.getManagersList().getFightInfoManager().getFightInfoById(fightInfoId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForFightInfo(fightInfo).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        if (!bindingResult.hasErrors()) {
            ObjectUtil.copyNotNullProperties((Object)fightInfo, (Object)fightInfoModel);
        }
        fightInfoModel.setPassword("");
        return "data/fightinfo-edit";
    }

    @MethodRight(value={Right.FIGHTINFOEDIT})
    @RequestMapping(value={"/edit/{fightInfoId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="fightInfoId") Long fightInfoId, @ModelAttribute(value="fightInfo") @Valid FightInfoModel fightInfoModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, fightInfoId, fightInfoModel, bindingResult);
        }
        FightInfo fightInfo = this.getManagersList().getFightInfoManager().getFightInfoById(fightInfoId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForFightInfo(fightInfo).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)fightInfoModel, (Object)fightInfo);
        fightInfo = this.getManagersList().getFightInfoManager().updateFightInfo(fightInfo);
        if (fightInfoModel.getPassword() != null && !fightInfoModel.getPassword().isEmpty()) {
            fightInfo.setPassword(fightInfoModel.getPassword());
            this.getManagersList().getFightInfoManager().updateFightInfoPassword(fightInfo);
        }
        return "redirect:/data/fight-info?messageCode=2";
    }

    @MethodRight(value={Right.FIGHTINFOEDIT})
    @RequestMapping(value={"/delete/{fightInfoId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="fightInfoId") Long fightInfoId) {
        FightInfo fightInfo = this.getManagersList().getFightInfoManager().getFightInfoById(fightInfoId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForFightInfo(fightInfo).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getFightInfoManager().deleteFightInfo(fightInfo);
        return "redirect:/data/fight-info?messageCode=3";
    }

    @MethodRight(value={Right.FIGHTINFOEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        return "data/fightinfo-import";
    }

    @MethodRight(value={Right.FIGHTINFOEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            List fightInfos = this.getManagersList().getFightInfoImporter().parseFightInfos(importDataModel.getFileType(), importDataModel.getFile().getBytes());
            this.getManagersList().getFightInfoImporter().importFightInfos(this.getUserData().getCompetition(), fightInfos);
            return "redirect:/data/fight-info?messageCode=4";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoFightInfoUsername) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "fightInfo.error.noUsername"));
                return this.importData(request, model, importDataModel);
            }
            if (e.getErrorType() == DataImportException.ErrorType.NoFightInfoPassword) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "fightInfo.error.noPassword"));
                return this.importData(request, model, importDataModel);
            }
            log.error("Error while reading fight info data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "fightInfo.error.importError"));
            return this.importData(request, model, importDataModel);
        }
        catch (Exception e) {
            log.error("Error while reading fight info data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "fightInfo.error.importError"));
            return this.importData(request, model, importDataModel);
        }
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "fightInfo.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        List fightInfos = this.getManagersList().getFightInfoManager().find(competition, new Page()).getData();
        String[] header = new String[]{this.getLanguageText(locale, "fightInfo.export.username"), this.getLanguageText(locale, "fightInfo.export.password")};
        try {
            byte[] data = this.getManagersList().getFightInfoImporter().exportFightInfos(fileType, fightInfos, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.error("Error writeing to output stream", (Throwable)e);
        }
    }
}

