/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers;

import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.captcha.Captcha;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.common.dl.query.SimplePage;
import si.nevensrok.jtekma.common.system.RecoverPasswordToken;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.common.RecoverPasswordModel;
import si.nevensrok.jtekma.server.web.controllers.ChangePasswordModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;

@Controller
@RequestMapping(value={"/recover-password"})
public class RecoverPasswordController
extends CoreController {
    private static final Logger log = LoggerFactory.getLogger(RecoverPasswordController.class);

    @RequestMapping(method={RequestMethod.GET})
    public String enterEmail(HttpServletRequest request, Model model, @ModelAttribute(value="recoverPassword") RecoverPasswordModel recoverPasswordModel) {
        return "recover-password/enter-email";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String enterEmailPost(HttpServletRequest request, Model model, @ModelAttribute(value="recoverPassword") RecoverPasswordModel recoverPasswordModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        if (this.getUserData().getRecoverPasswordCaptcha() == null || !this.getUserData().getRecoverPasswordCaptcha().equalsIgnoreCase(recoverPasswordModel.getCaptcha())) {
            model.addAttribute("errorMessage", (Object)this.getLanguageText(locale, "recoverPassword.error.invalidCaptcha"));
        } else {
            User example = new User();
            example.setEmail(recoverPasswordModel.getEmail().replaceAll("\\%", ""));
            example.setStatus(User.Status.ACTIVE);
            Page resultPage = this.getManagersList().getUserManager().findUsers((Page)new SimplePage((Object)example));
            if (!resultPage.getData().isEmpty()) {
                for (User user : resultPage.getData()) {
                    RecoverPasswordToken recoverPasswordToken = new RecoverPasswordToken();
                    recoverPasswordToken.setUser(user);
                    recoverPasswordToken.setCreatedDate(Calendar.getInstance().getTime());
                    recoverPasswordToken = this.getManagersList().getRecoverPasswordTokenManager().createRecoverPasswordToken(recoverPasswordToken);
                    String token = recoverPasswordToken.getId();
                    this.getTools().getEmailSenderTool().sendRecoverPasswordMail(locale, user, token);
                }
                model.addAttribute("infoMessage", (Object)this.getLanguageText(locale, "recoverPassword.text.emailSent"));
            } else {
                model.addAttribute("errorMessage", (Object)this.getLanguageText(locale, "recoverPassword.error.emailNotFound"));
            }
        }
        return "recover-password/enter-email";
    }

    @RequestMapping(value={"/captcha"})
    public void captchaImage(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/png");
        OutputStream outputStream = null;
        try {
            Captcha captcha = this.getTools().getCaptchaGenerator().generateCaptcha();
            this.getUserData().setRecoverPasswordCaptcha(captcha.getText());
            outputStream = response.getOutputStream();
            ImageIO.write((RenderedImage)captcha.getImage(), "PNG", outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error("Error displaying captcha", (Throwable)e);
        }
    }

    @RequestMapping(value={"/reset/{tokenId}"}, method={RequestMethod.GET})
    public String enterPassword(HttpServletRequest request, Model model, @PathVariable(value="tokenId") String tokenId, @ModelAttribute(value="password") ChangePasswordModel changePasswordModel) {
        RecoverPasswordToken recoverPasswordToken = this.getManagersList().getRecoverPasswordTokenManager().getPasswordToken(tokenId);
        model.addAttribute("tokenValid", (Object)(recoverPasswordToken != null ? 1 : 0));
        return "recover-password/change-password";
    }

    @RequestMapping(value={"/reset/{tokenId}"}, method={RequestMethod.POST})
    public String enterPasswordPost(HttpServletRequest request, Model model, @PathVariable(value="tokenId") String tokenId, @ModelAttribute(value="password") ChangePasswordModel changePasswordModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        RecoverPasswordToken recoverPasswordToken = this.getManagersList().getRecoverPasswordTokenManager().getPasswordToken(tokenId);
        model.addAttribute("tokenValid", (Object)(recoverPasswordToken != null ? 1 : 0));
        if (recoverPasswordToken != null) {
            if (changePasswordModel.getNewPassword().equals(changePasswordModel.getConfirmation())) {
                User user = recoverPasswordToken.getUser();
                user.setPassword(changePasswordModel.getNewPassword());
                this.getManagersList().getUserManager().updateUsersPassword(user);
                this.getManagersList().getRecoverPasswordTokenManager().deleteRecoverPasswordToken(recoverPasswordToken);
                model.addAttribute("infoMessage", (Object)this.getLanguageText(locale, "recoverPassword.text.passwordChanged"));
            } else {
                model.addAttribute("errorMessage", (Object)this.getLanguageText(locale, "recoverPassword.error.invalidConfirmation"));
            }
        }
        return "recover-password/change-password";
    }
}

