/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.jms.DefaultMessageBodyExtractor;
import si.nevensrok.common.jms.MessageBodyExtractor;
import si.nevensrok.common.jms.MessageCreator;

public class JmsRequestor
implements MessageListener,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JmsRequestor.class);
    private static final boolean transacted = false;
    private static final int acknowledgeMode = 1;
    private ConnectionFactory connectionFactory;
    private String destination;
    private int deliveryMode = 1;
    private int priority = -1;
    private int timeToLive = -1;
    private int responseTimeout = -1;
    private MessageBodyExtractor messageBodyExtractor;
    private Connection connection;
    private Map<String, Message> messages = new HashMap<String, Message>();

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setMessageBodyExtractor(MessageBodyExtractor messageBodyExtractor) {
        this.messageBodyExtractor = messageBodyExtractor;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("Property 'connectionFactory' is required");
        }
        if (this.destination == null) {
            throw new IllegalArgumentException("Property 'destination' is required");
        }
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        if (this.messageBodyExtractor == null) {
            this.messageBodyExtractor = new DefaultMessageBodyExtractor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<String, Message> map = this.messages;
        synchronized (map) {
            this.messages.clear();
            this.messages.notifyAll();
        }
    }

    public Object send(MessageCreator messageCreator) {
        String correlationId = null;
        Session session = null;
        Queue destinationQueue = null;
        MessageProducer producer = null;
        TemporaryQueue responseDestination = null;
        MessageConsumer responseConsumer = null;
        try {
            session = this.connection.createSession(false, 1);
            destinationQueue = session.createQueue(this.destination);
            producer = session.createProducer((Destination)destinationQueue);
            producer.setDeliveryMode(this.deliveryMode);
            if (this.priority > 0) {
                producer.setPriority(this.priority);
            }
            if (this.timeToLive > 0) {
                producer.setTimeToLive((long)this.timeToLive);
            }
            responseDestination = session.createTemporaryQueue();
            responseConsumer = session.createConsumer((Destination)responseDestination);
            responseConsumer.setMessageListener((MessageListener)this);
            Message message = messageCreator.createMessage(session);
            message.setJMSReplyTo((Destination)responseDestination);
            correlationId = this.generateId();
            message.setJMSCorrelationID(correlationId);
            log.trace("Sending message: {}", (Object)message);
            producer.send(message);
            Message responseMessage = this.getMessage(correlationId);
            Object object = this.messageBodyExtractor.getMessageBody(responseMessage);
            return object;
        }
        catch (Exception e) {
            log.trace("Error sending message", (Throwable)e);
            this.clearMessageId(correlationId);
            throw new RuntimeException("Error while sending JMS message", e);
        }
        finally {
            try {
                responseConsumer.close();
            }
            catch (Exception exception) {}
            try {
                responseDestination.delete();
            }
            catch (Exception exception) {}
            try {
                producer.close();
            }
            catch (Exception exception) {}
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        try {
            log.trace("JMS message received: {}", (Object)message);
            String correlationId = message.getJMSCorrelationID();
            if (correlationId == null || correlationId.isEmpty()) {
                throw new RuntimeException("CorrelationId not present");
            }
            Map<String, Message> map = this.messages;
            synchronized (map) {
                if (this.messages.containsKey(correlationId)) {
                    this.messages.put(correlationId, message);
                    this.messages.notifyAll();
                    return;
                }
            }
            log.warn("Not waiting for message with CorrelationId [{}]", (Object)correlationId);
        }
        catch (Exception e) {
            log.trace("Error handling message", (Throwable)e);
            throw new RuntimeException("Error handling message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateId() {
        for (int i = 0; i < 1000; ++i) {
            String correlationId = UUID.randomUUID().toString();
            Map<String, Message> map = this.messages;
            synchronized (map) {
                if (!this.messages.containsKey(correlationId)) {
                    this.messages.put(correlationId, null);
                    return correlationId;
                }
                continue;
            }
        }
        throw new RuntimeException("Error while generating CorrelationId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMessageId(String correlationId) {
        Map<String, Message> map = this.messages;
        synchronized (map) {
            this.messages.remove(correlationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message getMessage(String correlationId) {
        if (this.responseTimeout <= 0) {
            Map<String, Message> map = this.messages;
            synchronized (map) {
            }
        } else {
            long waitUntil = System.currentTimeMillis() + (long)this.responseTimeout;
            Map<String, Message> map = this.messages;
            synchronized (map) {
                while (true) {
                    if (this.messages.get(correlationId) != null) {
                        return this.messages.remove(correlationId);
                    }
                    if (!this.messages.containsKey(correlationId)) {
                        throw new RuntimeException("Reqeust message was cleared");
                    }
                    long waitTime = waitUntil - System.currentTimeMillis();
                    if (waitTime <= 0L) {
                        throw new RuntimeException("Response timeout expired");
                    }
                    try {
                        this.messages.wait(waitTime);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        {
            while (this.messages.get(correlationId) == null) {
                if (!this.messages.containsKey(correlationId)) {
                    throw new RuntimeException("Reqeust message was cleared");
                }
                try {
                    this.messages.wait();
                }
                catch (Exception exception) {
                }
            }
            return this.messages.remove(correlationId);
        }
    }
}

