/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.tcp;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.cache.AbstractCacheManager;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.tcp.CacheMessageHandler;
import si.nevensrok.common.cache.tcp.TcpCache;
import si.nevensrok.common.network.NetworkMessenger;
import si.nevensrok.common.network.tcp.ConnectionEstablishedHandler;
import si.nevensrok.common.network.tcp.DisconnectListener;
import si.nevensrok.common.network.tcp.SslTcpNetworkClient;
import si.nevensrok.common.network.tcp.SslTcpNetworkServer;
import si.nevensrok.common.network.tcp.TcpNetworkClient;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.network.tcp.TcpNetworkServer;
import si.nevensrok.common.ssl.SslContextGenerator;

public class TcpCacheManager
extends AbstractCacheManager
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TcpCacheManager.class);
    private Integer port;
    private SSLContext sslContext;
    private SslContextGenerator sslContextGenerator;
    private List<String> clients;
    private Map<String, TcpCache> cacheStore = new LinkedHashMap<String, TcpCache>();
    private TcpNetworkServer tcpNetworkServer;
    private List<TcpNetworkConnection> networkConnections = new LinkedList<TcpNetworkConnection>();
    private List<TcpNetworkClient> networkClients = new LinkedList<TcpNetworkClient>();

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SslContextGenerator getSslContextGenerator() {
        return this.sslContextGenerator;
    }

    public void setSslContextGenerator(SslContextGenerator sslContextGenerator) {
        this.sslContextGenerator = sslContextGenerator;
    }

    public List<String> getClients() {
        return this.clients;
    }

    public void setClients(List<String> clients) {
        this.clients = clients;
    }

    public void setClientsAsString(String clientText) {
        this.clients = Arrays.asList(clientText.split("[,;]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.port == null) {
            throw new IllegalArgumentException("Property 'port' is required");
        }
        final TcpCacheManager tcpCacheManager = this;
        if (this.sslContext != null || this.sslContextGenerator != null) {
            this.tcpNetworkServer = new SslTcpNetworkServer();
            ((SslTcpNetworkServer)this.tcpNetworkServer).setSslContext(this.sslContext);
            ((SslTcpNetworkServer)this.tcpNetworkServer).setSslContextGenerator(this.sslContextGenerator);
        } else {
            this.tcpNetworkServer = new TcpNetworkServer();
        }
        this.tcpNetworkServer.setPort(this.port);
        this.tcpNetworkServer.setConnectionEstablishedHandler(new ConnectionEstablishedHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionAccepted(final TcpNetworkConnection networkConnection) {
                List list = TcpCacheManager.this.networkConnections;
                synchronized (list) {
                    TcpCacheManager.this.networkConnections.add(networkConnection);
                }
                networkConnection.setDisconnectListener(new DisconnectListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void disconnected(TcpNetworkConnection tcpNetworkConnection) {
                        List list = TcpCacheManager.this.networkConnections;
                        synchronized (list) {
                            TcpCacheManager.this.networkConnections.remove(networkConnection);
                        }
                    }
                });
                new CacheMessageHandler(tcpCacheManager, networkConnection);
            }
        });
        this.tcpNetworkServer.afterPropertiesSet();
        if (this.clients != null || !this.clients.isEmpty()) {
            for (String client : this.clients) {
                TcpNetworkClient tcpNetwokClient;
                URI uri = new URI(client);
                if (client.startsWith("tcp://")) {
                    tcpNetwokClient = new TcpNetworkClient();
                } else {
                    if (!client.startsWith("ssl://")) continue;
                    tcpNetwokClient = new SslTcpNetworkClient();
                }
                tcpNetwokClient.setAddress(uri.getHost());
                tcpNetwokClient.setPort(uri.getPort());
                tcpNetwokClient.afterPropertiesSet();
                List<TcpNetworkClient> list = this.networkClients;
                synchronized (list) {
                    this.networkClients.add(tcpNetwokClient);
                }
                new CacheMessageHandler(tcpCacheManager, tcpNetwokClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            this.tcpNetworkServer.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (TcpNetworkClient networkClient : this.getTcpNetworkClientList()) {
            try {
                networkClient.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        List<TcpNetworkConnection> list = this.networkConnections;
        synchronized (list) {
            this.networkConnections.clear();
        }
        List<TcpNetworkClient> list2 = this.networkClients;
        synchronized (list2) {
            this.networkClients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpCache getCache(String name) {
        TcpCache cache;
        Map<String, TcpCache> map = this.cacheStore;
        synchronized (map) {
            cache = this.cacheStore.get(name);
            if (cache == null) {
                CacheSettings settings = this.getCacheSettings().get(name);
                if (settings == null) {
                    settings = this.getDefaultCacheSettings();
                }
                cache = new TcpCache(name, settings, this);
                this.cacheStore.put(name, cache);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCacheNames() {
        Map<String, TcpCache> map = this.cacheStore;
        synchronized (map) {
            return new LinkedList<String>(this.cacheStore.keySet());
        }
    }

    void sentMessageToAllNodes(Object message) {
        for (TcpNetworkConnection tcpNetworkConnection : this.getTcpNetworkConnectionList()) {
            try {
                tcpNetworkConnection.sendMessage(message);
            }
            catch (Throwable e) {
                log.trace("Error sending message to tcp network connection", e);
            }
        }
        for (NetworkMessenger networkMessenger : this.getTcpNetworkClientList()) {
            try {
                ((TcpNetworkClient)networkMessenger).sendMessage(message);
            }
            catch (Throwable e) {
                log.trace("Error sending message to tcp network client", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TcpNetworkConnection[] getTcpNetworkConnectionList() {
        List<TcpNetworkConnection> list = this.networkConnections;
        synchronized (list) {
            return this.networkConnections.toArray(new TcpNetworkConnection[this.networkConnections.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TcpNetworkClient[] getTcpNetworkClientList() {
        List<TcpNetworkClient> list = this.networkClients;
        synchronized (list) {
            return this.networkClients.toArray(new TcpNetworkClient[this.networkClients.size()]);
        }
    }
}

