/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.NextMatchData;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaServiceClient;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.gui.DuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.InjuryTimeDialog;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;

public class TablaManager
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(TablaManager.class);
    private ApplicationContext applicationContext;
    private MatchPanel matchPanel;
    private MatchData matchData;
    private TablaWindow tablaWindow;
    private RulesManager rulesManager;
    private FightPoints fightPoints;
    private DuoPoints duoPoints;
    private NewazaPoints newazaPoints;
    private TimeTracker timeTracker;
    private DuoPointsPanel duoPointsPanel;
    private InjuryTimeDialog injuryTimeDialog;
    private TablaServiceClient tablaService;
    private Object matchMonitor = new Object();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchPanel(MatchPanel matchPanel) {
        this.matchPanel = matchPanel;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaWindow(TablaWindow tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPoints = fightPoints;
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPoints = duoPoints;
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPoints = newazaPoints;
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    public void setDuoPointsPanel(DuoPointsPanel duoPointsPanel) {
        this.duoPointsPanel = duoPointsPanel;
    }

    public void setInjuryTimeDialog(InjuryTimeDialog injuryTimeDialog) {
        this.injuryTimeDialog = injuryTimeDialog;
    }

    public void setTablaService(TablaServiceClient tablaService) {
        this.tablaService = tablaService;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTable() {
        this.timeTracker.stopTime();
        this.timeTracker.stopHosekomiTime();
        Object object = this.matchMonitor;
        synchronized (object) {
            this.matchData.setMatch(null);
        }
        this.matchData.setName1("");
        this.matchData.setClub1("");
        this.matchData.setName2("");
        this.matchData.setClub2("");
        this.matchData.setCategory("");
        this.matchData.setTimeLeft(this.matchData.getDefaultMatchTime());
        this.matchData.setTimeFromStart(0L);
        this.matchData.setHosekomiTime(0L);
        for (int i = 0; i < this.matchData.getLastHostkomis().length; ++i) {
            this.matchData.getLastHostkomis()[i] = 0L;
        }
        this.fightPoints.setWazari1(0);
        this.fightPoints.setIppon1_1(0);
        this.fightPoints.setIppon1_2(0);
        this.fightPoints.setIppon1_3(0);
        this.fightPoints.setIppon1_3p(0);
        this.fightPoints.setShido1(0);
        this.fightPoints.setChui1(0);
        this.fightPoints.setHansokumake1(0);
        this.fightPoints.setWazari2(0);
        this.fightPoints.setIppon2_1(0);
        this.fightPoints.setIppon2_2(0);
        this.fightPoints.setIppon2_3(0);
        this.fightPoints.setIppon2_3p(0);
        this.fightPoints.setShido2(0);
        this.fightPoints.setChui2(0);
        this.fightPoints.setHansokumake2(0);
        this.fightPoints.clearPointDetails();
        for (int round = 1; round <= 5; ++round) {
            for (int judge = 1; judge <= 5; ++judge) {
                this.duoPoints.setPoints1(round, judge, 0.0f);
                this.duoPoints.setPoints2(round, judge, 0.0f);
            }
        }
        this.duoPointsPanel.resetPoints();
        if (this.matchData.getTableType() == TableType.DUO) {
            this.duoPointsPanel.selectFirstField();
        }
        this.newazaPoints.setPoint1_2(0);
        this.newazaPoints.setPoint1_3(0);
        this.newazaPoints.setPoint1_4(0);
        this.newazaPoints.setPoint1_100(0);
        this.newazaPoints.setAdvantage1(0);
        this.newazaPoints.setPenalty1(0);
        this.newazaPoints.setHansokumake1(0);
        this.newazaPoints.setPoint2_2(0);
        this.newazaPoints.setPoint2_3(0);
        this.newazaPoints.setPoint2_4(0);
        this.newazaPoints.setPoint2_100(0);
        this.newazaPoints.setAdvantage2(0);
        this.newazaPoints.setPenalty2(0);
        this.newazaPoints.setHansokumake2(0);
        this.fightPoints.clearPointDetails();
        this.recalculatePoints();
        this.injuryTimeDialog.resetTime();
        this.matchPanel.redrawElements();
    }

    public void recalculatePoints() {
        log.debug("Recalculation points for match type {}", (Object)this.matchData.getTableType());
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(this.matchData.getRules());
        if (competitionRules == null) {
            log.error("Competition rules not found");
            return;
        }
        if (this.matchData.getTableType() == TableType.FIGHT) {
            Set<MatchPoint> matchPoints = this.fightPoints.getMatchPoints();
            float points1 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR1, matchPoints);
            float points2 = competitionRules.sumPointsFor(Match.Type.FIGHT, CompetitorType.COMPETITOR2, matchPoints);
            this.matchPanel.setPoints1(points1);
            this.matchPanel.setPoints2(points2);
            this.matchPanel.redrawElements();
            if (competitionRules.isFullIpponFor(CompetitorType.COMPETITOR1, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner1();
            } else if (competitionRules.isFullIpponFor(CompetitorType.COMPETITOR2, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner2();
            } else if (competitionRules.isDisqualificationFor(Match.Type.FIGHT, CompetitorType.COMPETITOR1, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner2();
            } else if (competitionRules.isDisqualificationFor(Match.Type.FIGHT, CompetitorType.COMPETITOR2, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner1();
            }
        } else if (this.matchData.getTableType() == TableType.DUO) {
            Set<MatchPoint> matchPoints = this.duoPoints.getMatchPoints();
            float points1 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR1, matchPoints);
            float points2 = competitionRules.sumPointsFor(Match.Type.DUO, CompetitorType.COMPETITOR2, matchPoints);
            this.matchPanel.setPoints1(points1);
            this.matchPanel.setPoints2(points2);
            this.duoPointsPanel.recalculateRoundPoints();
            this.matchPanel.redrawElements();
        } else if (this.matchData.getTableType() == TableType.NEWAZA) {
            Set<MatchPoint> matchPoints = this.newazaPoints.getMatchPoints();
            float points1 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR1, matchPoints);
            float points2 = competitionRules.sumPointsFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR2, matchPoints);
            this.matchPanel.setPoints1(points1);
            this.matchPanel.setPoints2(points2);
            this.matchPanel.redrawElements();
            if (competitionRules.isFinishingMove(CompetitorType.COMPETITOR1, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner1();
            } else if (competitionRules.isFinishingMove(CompetitorType.COMPETITOR2, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner2();
            } else if (competitionRules.isDisqualificationFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR1, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner2();
            } else if (competitionRules.isDisqualificationFor(Match.Type.NEWAZA, CompetitorType.COMPETITOR2, matchPoints)) {
                this.timeTracker.stopTime();
                this.timeTracker.stopHosekomiTime();
                this.matchPanel.setWinner1();
            }
        }
    }

    public void selectWinner() {
        CompetitionRules competitionRules;
        if (log.isDebugEnabled()) {
            log.debug("Selecting winner for match type {}", (Object)this.matchData.getTableType());
        }
        if ((competitionRules = this.rulesManager.getCompetitionRules(this.matchData.getRules())) == null) {
            log.error("Competition rules not found");
            return;
        }
        Competitor competitor1 = new Competitor();
        competitor1.setCompetitorId(Long.valueOf(1L));
        Competitor competitor2 = new Competitor();
        competitor2.setCompetitorId(Long.valueOf(2L));
        Match match = new Match();
        match.setCompetitor1(competitor1);
        match.setCompetitor2(competitor2);
        if (this.matchData.getTableType() == TableType.FIGHT) {
            Set<MatchPoint> matchPoints = this.fightPoints.getMatchPoints();
            match.setType(Match.Type.FIGHT);
            Competitor winner = competitionRules.getMatchWinner(match, matchPoints);
            if (winner != null) {
                if (winner.getCompetitorId().equals(competitor1.getCompetitorId())) {
                    this.matchPanel.setWinner1();
                } else if (winner.getCompetitorId().equals(competitor2.getCompetitorId())) {
                    this.matchPanel.setWinner2();
                }
            } else {
                this.tablaWindow.showDrawMessage();
            }
        } else if (this.matchData.getTableType() == TableType.DUO) {
            Set<MatchPoint> matchPoints = this.duoPoints.getMatchPoints();
            match.setType(Match.Type.DUO);
            Competitor winner = competitionRules.getMatchWinner(match, matchPoints);
            if (winner != null) {
                if (winner.getCompetitorId().equals(competitor1.getCompetitorId())) {
                    this.matchPanel.setWinner1();
                } else if (winner.getCompetitorId().equals(competitor2.getCompetitorId())) {
                    this.matchPanel.setWinner2();
                }
            } else {
                this.tablaWindow.showDrawMessage();
            }
        } else if (this.matchData.getTableType() == TableType.NEWAZA) {
            Set<MatchPoint> matchPoints = this.newazaPoints.getMatchPoints();
            match.setType(Match.Type.NEWAZA);
            Competitor winner = competitionRules.getMatchWinner(match, matchPoints);
            if (winner != null) {
                if (winner.getCompetitorId().equals(competitor1.getCompetitorId())) {
                    this.matchPanel.setWinner1();
                } else if (winner.getCompetitorId().equals(competitor2.getCompetitorId())) {
                    this.matchPanel.setWinner2();
                }
            } else {
                this.tablaWindow.showDrawMessage();
            }
        }
    }

    public boolean checkLogin(Credentials credentials) {
        this.tablaService.setup(credentials.getUrl());
        return this.tablaService.checkLogin(credentials);
    }

    public void fectNextMatch() {
        if (this.matchData.getMatch() != null) {
            int n = JOptionPane.showConfirmDialog(this.tablaWindow, this.getLanguageText("text.ignoreCurrentMatch"), this.getLanguageText("title.confirmation"), 1, 2);
            if (n == 0) {
                this.resetTable();
            } else if (n == 2) {
                return;
            }
        }
        Thread thread = new Thread("Match fetching thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NextMatchData nextMatchData = null;
                try {
                    nextMatchData = TablaManager.this.tablaService.getNextMatch(TablaManager.this.matchData.getCredentials());
                }
                catch (Exception e) {
                    log.error("Error while fetching next match", e);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Next match data fetched {}", nextMatchData);
                }
                if (nextMatchData == null) {
                    JOptionPane.showMessageDialog(TablaManager.this.tablaWindow, TablaManager.this.getLanguageText("text.noMatch"), TablaManager.this.getLanguageText("title.error"), 0);
                } else {
                    TablaManager.this.resetTable();
                    Object object = TablaManager.this.matchMonitor;
                    synchronized (object) {
                        Competitor competitor2;
                        Match match = nextMatchData.getMatch();
                        if (nextMatchData.getMatchTime() != null) {
                            TablaManager.this.matchData.setTimeLeft(nextMatchData.getMatchTime().longValue() * 1000L);
                        }
                        if (nextMatchData.getHosekomiTime() != null) {
                            TablaManager.this.matchData.setMaximumHosekomiTime(nextMatchData.getHosekomiTime().longValue() * 1000L);
                        }
                        if (nextMatchData.getRules() != null) {
                            TablaManager.this.matchData.setRules(nextMatchData.getRules());
                        }
                        if (nextMatchData.getInjuryTime1() != null) {
                            TablaManager.this.injuryTimeDialog.setInjuryTime1(nextMatchData.getInjuryTime1() * 1000);
                        }
                        if (nextMatchData.getInjuryTime2() != null) {
                            TablaManager.this.injuryTimeDialog.setInjuryTime2(nextMatchData.getInjuryTime2() * 1000);
                        }
                        if (nextMatchData.getMatchPoints() != null) {
                            if (match.getType() == Match.Type.FIGHT) {
                                TablaManager.this.fightPoints.setMatchPoints(nextMatchData.getMatchPoints());
                            } else if (match.getType() == Match.Type.DUO) {
                                TablaManager.this.duoPoints.setMatchPoints(nextMatchData.getMatchPoints());
                                TablaManager.this.duoPointsPanel.resetPoints();
                                TablaManager.this.duoPointsPanel.selectFirstField();
                            } else if (match.getType() == Match.Type.NEWAZA) {
                                TablaManager.this.newazaPoints.setMatchPoints(nextMatchData.getMatchPoints());
                            }
                        }
                        TablaManager.this.matchData.setMatch(match);
                        TablaManager.this.matchData.setCategory(match.getCategory().getName());
                        Competitor competitor1 = match.getCompetitor1();
                        if (competitor1 != null) {
                            if (competitor1 instanceof PersonCompetitor) {
                                PersonCompetitor personCompetitor = (PersonCompetitor)competitor1;
                                TablaManager.this.matchData.setName1(personCompetitor.getShortName());
                            }
                            if (competitor1 instanceof CoupleCompetitor) {
                                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor1;
                                TablaManager.this.matchData.setName1(coupleCompetitor.getShortName());
                            }
                            TablaManager.this.matchData.setClub1(competitor1.getClub().getShortName());
                        }
                        if ((competitor2 = match.getCompetitor2()) != null) {
                            if (competitor2 instanceof PersonCompetitor) {
                                PersonCompetitor personCompetitor = (PersonCompetitor)competitor2;
                                TablaManager.this.matchData.setName2(personCompetitor.getShortName());
                            }
                            if (competitor2 instanceof CoupleCompetitor) {
                                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor2;
                                TablaManager.this.matchData.setName2(coupleCompetitor.getShortName());
                            }
                            TablaManager.this.matchData.setClub2(competitor2.getClub().getShortName());
                        }
                        if (match.getType() == Match.Type.FIGHT) {
                            TablaManager.this.matchData.setTableType(TableType.FIGHT);
                        } else if (match.getType() == Match.Type.DUO) {
                            TablaManager.this.matchData.setTableType(TableType.DUO);
                        } else if (match.getType() == Match.Type.NEWAZA) {
                            TablaManager.this.matchData.setTableType(TableType.NEWAZA);
                        } else {
                            log.warn("Unknown match type {}", match.getType());
                        }
                    }
                    TablaManager.this.recalculatePoints();
                    TablaManager.this.matchPanel.redrawElements();
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMatch() {
        Credentials credentials = null;
        Match match = null;
        Set<MatchPoint> matchPoints = null;
        Set<PointDetail> pointDetails = null;
        Integer fightTimeLeft = null;
        Integer injuryTime1 = null;
        Integer injuryTime2 = null;
        Object object = this.matchMonitor;
        synchronized (object) {
            credentials = this.matchData.getCredentials();
            match = this.matchData.getMatch();
            injuryTime1 = this.injuryTimeDialog.getInjuryTime1() / 1000;
            injuryTime2 = this.injuryTimeDialog.getInjuryTime2() / 1000;
            if (this.matchData.getTableType() == TableType.FIGHT) {
                matchPoints = this.fightPoints.getMatchPoints();
                pointDetails = this.fightPoints.getPointDetails();
                fightTimeLeft = (int)(this.matchData.getTimeLeft() / 1000L);
            } else if (this.matchData.getTableType() == TableType.DUO) {
                matchPoints = this.duoPoints.getMatchPoints();
                pointDetails = new HashSet<PointDetail>();
            } else if (this.matchData.getTableType() == TableType.NEWAZA) {
                matchPoints = this.newazaPoints.getMatchPoints();
                pointDetails = this.newazaPoints.getPointDetails();
                fightTimeLeft = (int)(this.matchData.getTimeLeft() / 1000L);
            }
        }
        if (credentials != null && match != null && matchPoints != null && pointDetails != null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.matchData.getTableType() == TableType.FIGHT ? this.fightPoints.arePointsEmpty() && JOptionPane.showConfirmDialog(this.tablaWindow, this.getLanguageText("text.sendEmptyMatch"), this.getLanguageText("title.confirmation"), 1, 2) != 0 : (this.matchData.getTableType() == TableType.DUO ? this.duoPoints.getSum1() <= 0.0f && this.duoPoints.getSum2() <= 0.0f && JOptionPane.showConfirmDialog(this.tablaWindow, this.getLanguageText("text.sendEmptyMatch"), this.getLanguageText("title.confirmation"), 1, 2) != 0 : this.matchData.getTableType() == TableType.NEWAZA && this.newazaPoints.arePointsEmpty() && JOptionPane.showConfirmDialog(this.tablaWindow, this.getLanguageText("text.sendEmptyMatch"), this.getLanguageText("title.confirmation"), 1, 2) != 0)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Sending match finish data");
            }
            try {
                this.tablaService.finishMatch(credentials, match, matchPoints, pointDetails, fightTimeLeft, injuryTime1, injuryTime2);
                object = this.matchMonitor;
                synchronized (object) {
                    this.matchData.setMatch(null);
                }
                this.resetTable();
            }
            catch (Exception e) {
                log.error("Error while finishing match", e);
                this.matchData.setMatch(match);
                JOptionPane.showMessageDialog(this.tablaWindow, this.getLanguageText("text.errorFinishing"), this.getLanguageText("title.error"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this.tablaWindow, this.getLanguageText("text.matchNotFromServer"), this.getLanguageText("title.error"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPartialData() {
        Credentials credentials = null;
        Match match = null;
        Set<MatchPoint> matchPoints = null;
        Integer fightTimeLeft = null;
        Integer injuryTime1 = null;
        Integer injuryTime2 = null;
        Object object = this.matchMonitor;
        synchronized (object) {
            credentials = this.matchData.getCredentials();
            match = this.matchData.getMatch();
            injuryTime1 = this.injuryTimeDialog.getInjuryTime1() / 1000;
            injuryTime2 = this.injuryTimeDialog.getInjuryTime2() / 1000;
            if (this.matchData.getTableType() == TableType.FIGHT) {
                matchPoints = this.fightPoints.getMatchPoints();
                fightTimeLeft = (int)(this.matchData.getTimeLeft() / 1000L);
            } else if (this.matchData.getTableType() == TableType.DUO) {
                matchPoints = this.duoPoints.getMatchPoints();
            } else if (this.matchData.getTableType() == TableType.NEWAZA) {
                matchPoints = this.newazaPoints.getMatchPoints();
                fightTimeLeft = (int)(this.matchData.getTimeLeft() / 1000L);
            }
        }
        if (credentials != null && match != null && matchPoints != null) {
            if (log.isDebugEnabled()) {
                log.debug("Sending match partial data");
            }
            try {
                this.tablaService.setPartialData(credentials, match, matchPoints, fightTimeLeft, injuryTime1, injuryTime2);
            }
            catch (Exception e) {
                log.error("Error while sending partial data", e);
            }
        }
    }
}

