(function() {
	window.jtekma.weighing={};
	
	//search
	window.jtekma.weighing.search={};
	
	window.jtekma.weighing.search.model=Backbone.Model.extend({
		"defaults": {
			"name":"",
			"club":"",
			"displayPerPage":20
		}
	});
	
	window.jtekma.weighing.search.view=Backbone.View.extend({
		"template":templates.getWeighingSearchTemplate(),
		"initialize":function() {
			this.model.on("change",function() {
				
			},this);
		},
		"render":function() {
			var obj=this;
			
			var data=this.model.toJSON();
			$(this.el).html(Mustache.render(this.template,data));
			
			$("select[name='displayPerPage']" ,this.el).val(data.displayPerPage);
			
			$("[rel='tooltip']", this.el).tooltip();
			
			$(".chosen-select", this.el).each(function(index) {
				var width=$(this).attr("width");
				var options={
					"search_contains":true
				};
				if (width) {
					options.width=width;
				}
				$(this).chosen(options);
			});
			
			$("input[name='name'], input[name='club'], select[name='displayPerPage']" ,this.el).on("change", function() {
				obj.model.set($(this).attr("name"), $(this).val());
			});
			
			$("button" ,this.el).on("click", function() {
				obj.model.trigger("change");
			});
			
			return this;
		}
	});
	
	//competitors
	window.jtekma.weighing.competitor={};
	
	window.jtekma.weighing.competitor.model=Backbone.Model.extend({
		"defaults": {
			"id":0,
			"name":"",
			"surname":"",
			"clubName":"",
			"categories":[],
			"yearOfBirth":0,
			"weight":0
		}
	});
	
	window.jtekma.weighing.competitor.collection=Backbone.Collection.extend({
		"url":function() { return contextPath+"/weighing/competitors"; },
		"model":window.jtekma.weighing.competitor.model,
		"fetch":function(searchData) {
			var obj=this;
			$.ajax({
				"url":obj.url(),
				"type": "POST",
				"contentType": "application/json; charset=utf-8",
				"data":JSON.stringify(searchData),
				success: function(responseData) {
					obj.reset(responseData);
				}
			});
		}
	});
	
	window.jtekma.weighing.competitor.rowView=Backbone.View.extend({
		"template":templates.getWeighingCompetitorRowTemplate(),
		"initialize":function() {
			this.model.on("change",function() {
				this.reloadData();
			},this);
		},
		"render":function() {
			var obj=this;
			
			var data=this.model.toJSON();
			
			$(this.el).html(Mustache.render(this.template,data));
			
			$("select[name='categories']" ,this.el).val(this.model.get("categories"));
			
			$("[rel='tooltip']", this.el).tooltip();
			
			$(".chosen-select", this.el).each(function(index) {
				var width=$(this).attr("width");
				var options={
					"search_contains":true
				};
				if (width) {
					options.width=width;
				}
				$(this).chosen(options);
			});
			
			$("button.save", this.el).on("click", function() {
				var comeptitorData=obj.model.toJSON();
				comeptitorData.weight=Number($("input[name='weight']", obj.el).val());
				comeptitorData.yearOfBirth=Number($("input[name='yearOfBirth']", obj.el).val());
				comeptitorData.categories=[];
				
				var selectedCategories=$("select[name='categories']", obj.el).val();
				
				for (var i=0;i<selectedCategories.length;i++) {
					comeptitorData.categories.push(Number(selectedCategories[i]));
				}
				
				$.ajax({
					"url": contextPath+"/weighing/save-competitor",
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data":JSON.stringify(comeptitorData),
					success: function(responseData) {
						obj.model.set("weight", comeptitorData.weight);
						obj.model.set("yearOfBirth", comeptitorData.yearOfBirth);
						obj.model.set("categories", comeptitorData.categories);
						obj.reloadData();
					}
				});
			});
			
			$("button.reset", this.el).on("click", function() {
				obj.reloadData();
			});
			
			$("input[name='weight'], input[name='yearOfBirth'], select[name='categories']", this.el).on("change", function() {
				obj.markChange();
			});
			
			return this;
		},
		"reloadData":function() {
			$("input[name='weight']", this.el).val(this.model.get("weight"));
			$("input[name='yearOfBirth']", this.el).val(this.model.get("yearOfBirth"));
			
			$("select[name='categories']" ,this.el).val(this.model.get("categories"));
			$("select[name='categories']" ,this.el).trigger("liszt:updated");
			$("select[name='categories']" ,this.el).trigger('chosen:updated');
			
			this.markChange();
		},
		"markChange":function() {
			var hasChanged=false;
			
			hasChanged=hasChanged || $("input[name='weight']", this.el).val()!=this.model.get("weight");
			hasChanged=hasChanged || $("input[name='yearOfBirth']", this.el).val()!=this.model.get("yearOfBirth");
			
			var currentCategories=this.model.get("categories");
			var selectedCategories=$("select[name='categories']" ,this.el).val();
			hasChanged=hasChanged || currentCategories.length!=selectedCategories.length;
			for (var i=0;i<currentCategories.length;i++) {
				hasChanged=hasChanged || selectedCategories.indexOf(currentCategories[i])>=0;
			}
			
			if (hasChanged) {
				$(this.el).addClass("hasChanged");
			}
			else {
				$(this.el).removeClass("hasChanged");
			}
		}
	});
	
	window.jtekma.weighing.competitor.tableView=Backbone.View.extend({
		"template":templates.getWeighingCompetitorsTemplate(),
		"initialize":function() {
			this.collection.on("reset",function() {
				this.render();
			},this);
		},
		"render":function() {
			var obj=this;
			
			var data={};
			
			$(this.el).html(Mustache.render(this.template,data));
			
			this.collection.each(function(element) {
				var row=new window.jtekma.weighing.competitor.rowView({
					"tagName": "tr",
					"model":element
				});
				$("tbody", obj.el).append(row.render().el);
			});
			
			return this;
		}
	});
	
})();

$(document).ready(function() {
	var searchModel=new window.jtekma.weighing.search.model();
	var competitorCollection=new window.jtekma.weighing.competitor.collection();
	
	var searchView=new window.jtekma.weighing.search.view({
		"el":$("#searchDiv"),
		"model":searchModel
	});
	
	searchView.render();
	
	new window.jtekma.weighing.competitor.tableView({
		"el":$("#competitorsDiv"),
		"collection":competitorCollection
	});
	
	searchModel.on("change",function() {
		competitorCollection.fetch(searchModel.toJSON());
	});
	
	searchModel.trigger("change");
	
});
