/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.system;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import si.nevensrok.jtekma.common.system.Role;
import si.nevensrok.jtekma.server.dl.dto.competition.CompetitionDTO;
import si.nevensrok.jtekma.server.dl.dto.system.UserDTO;

@Entity
@Table(name="usercompetitionroles")
public class UserCompetitionRoleDTO {
    @Id
    private UserCompetitionRoleKey userCompetitionRoleKey;
    @Enumerated(value=EnumType.STRING)
    @Column(length=32, name="role", nullable=false, updatable=true)
    private Role role;

    public UserCompetitionRoleDTO() {
    }

    public UserCompetitionRoleDTO(UserDTO user, CompetitionDTO competition) {
        this.userCompetitionRoleKey = new UserCompetitionRoleKey(user, competition);
    }

    public UserCompetitionRoleKey getUserCompetitionRoleKey() {
        return this.userCompetitionRoleKey;
    }

    public void setUserCompetitionRoleKey(UserCompetitionRoleKey userCompetitionRoleKey) {
        this.userCompetitionRoleKey = userCompetitionRoleKey;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String toString() {
        return "UserCompetitionRoleDTO [userCompetitionRoleKey=" + this.userCompetitionRoleKey + ", role=" + this.role + "]";
    }

    @Embeddable
    public static class UserCompetitionRoleKey
    implements Serializable {
        private static final long serialVersionUID = 3523984821769284147L;
        @ManyToOne(fetch=FetchType.EAGER)
        @JoinColumn(name="userid", nullable=false, updatable=false)
        private UserDTO user;
        @ManyToOne(fetch=FetchType.EAGER)
        @JoinColumn(name="competitionid", nullable=false, updatable=false)
        private CompetitionDTO competition;

        public UserCompetitionRoleKey() {
        }

        public UserCompetitionRoleKey(UserDTO user, CompetitionDTO competition) {
            this.user = user;
            this.competition = competition;
        }

        public UserDTO getUser() {
            return this.user;
        }

        public void setUser(UserDTO user) {
            this.user = user;
        }

        public CompetitionDTO getCompetition() {
            return this.competition;
        }

        public void setCompetition(CompetitionDTO competition) {
            this.competition = competition;
        }

        public String toString() {
            return "UserCompetitionRoleKey [user=" + (Object)((Object)this.user) + ", competition=" + (Object)((Object)this.competition) + "]";
        }
    }
}

