/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.Gender;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.WeightCategoryOption;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.dl.dto.category.WeightCategoryOptionDTO;

public class WeightCategoryOptionDAO
extends ExtendedDao<Long, WeightCategoryOptionDTO, WeightCategoryOption> {
    public WeightCategoryOptionDAO() {
        super(WeightCategoryOptionDTO.class, WeightCategoryOption.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.compareToIgnoreCase("id") == 0) {
            return "c.id";
        }
        if (fieldName.compareToIgnoreCase("weightCategoryOptionId") == 0) {
            return "c.id";
        }
        if (fieldName.compareToIgnoreCase("weight") == 0) {
            return "c.weight";
        }
        if (fieldName.compareToIgnoreCase("isAbsolute") == 0) {
            return "c.isAbsolute";
        }
        if (fieldName.compareToIgnoreCase("gender") == 0) {
            return "c.gender";
        }
        if (fieldName.compareToIgnoreCase("status") == 0) {
            return "c.status";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public WeightCategoryOption getForCategory(FightingCategory fightingCategory) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select fightingCategory.weightCategoryOption from FightingCategoryDTO as fightingCategory where fightingCategory.id=");
        sql.append(params.addParam(fightingCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        WeightCategoryOptionDTO weightCategoryOptionDTO = (WeightCategoryOptionDTO)((Object)WeightCategoryOptionDAO.getSingleResult((Query)query));
        WeightCategoryOption weightCategoryOption = null;
        if (weightCategoryOptionDTO != null) {
            weightCategoryOption = (WeightCategoryOption)this.adapterPool.create(WeightCategoryOption.class, (Object)weightCategoryOptionDTO);
        }
        this.flush();
        return weightCategoryOption;
    }

    public WeightCategoryOption getForCategory(NewazaCategory newazaCategory) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select newazaCategory.weightCategoryOption from NewazaCategoryDTO as newazaCategory where newazaCategory.id=");
        sql.append(params.addParam(newazaCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        WeightCategoryOptionDTO weightCategoryOptionDTO = (WeightCategoryOptionDTO)((Object)WeightCategoryOptionDAO.getSingleResult((Query)query));
        WeightCategoryOption weightCategoryOption = null;
        if (weightCategoryOptionDTO != null) {
            weightCategoryOption = (WeightCategoryOption)this.adapterPool.create(WeightCategoryOption.class, (Object)weightCategoryOptionDTO);
        }
        this.flush();
        return weightCategoryOption;
    }

    public WeightCategoryOption getActiveWeightCategory(Integer weight, Boolean isAbsolute, Gender gender) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select weightCategoryOption from WeightCategoryOptionDTO as weightCategoryOption where weightCategoryOption.weight=");
        sql.append(params.addParam(weight));
        sql.append(" and weightCategoryOption.isAbsolute=");
        sql.append(params.addParam(isAbsolute));
        sql.append(" and weightCategoryOption.gender=");
        sql.append(params.addParam((Object)gender));
        sql.append(" and weightCategoryOption.status=");
        sql.append(params.addParam((Object)WeightCategoryOption.Status.ACTIVE));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        WeightCategoryOptionDTO weightCategoryOptionDTO = (WeightCategoryOptionDTO)((Object)WeightCategoryOptionDAO.getSingleResult((Query)query));
        WeightCategoryOption weightCategoryOption = null;
        if (weightCategoryOptionDTO != null) {
            weightCategoryOption = (WeightCategoryOption)this.adapterPool.create(WeightCategoryOption.class, (Object)weightCategoryOptionDTO);
        }
        this.flush();
        return weightCategoryOption;
    }

    public List<WeightCategoryOption> getActiveWeightCategoriesForCompetitions(Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select weightCategoryOption from WeightCategoryOptionDTO as weightCategoryOption where weightCategoryOption.status=");
        sql.append(params.addParam((Object)WeightCategoryOption.Status.ACTIVE));
        sql.append(" and ((select count(*) from FightingCategoryDTO as fightingCategory where fightingCategory.weightCategoryOption.id=weightCategoryOption.id and fightingCategory.competition.id=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(")>0");
        sql.append(" or (select count(*) from NewazaCategoryDTO as newazaCategory where newazaCategory.weightCategoryOption.id=weightCategoryOption.id and newazaCategory.competition.id=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(")>0)");
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<WeightCategoryOption> weightCategoryOptions = new LinkedList<WeightCategoryOption>();
        for (WeightCategoryOptionDTO weightCategoryOptionDTO : list) {
            weightCategoryOptions.add((WeightCategoryOption)this.adapterPool.create(WeightCategoryOption.class, (Object)weightCategoryOptionDTO));
        }
        this.flush();
        return weightCategoryOptions;
    }
}

