/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.server.dl.dto.rules.TreeAdvancmentDTO;

public class TreeAdvancmentDAO
extends ExtendedDao<Long, TreeAdvancmentDTO, TreeAdvancment> {
    public TreeAdvancmentDAO() {
        super(TreeAdvancmentDTO.class, TreeAdvancment.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.compareToIgnoreCase("id") == 0) {
            return "c.id";
        }
        if (fieldName.compareToIgnoreCase("treeAdvancmentId") == 0) {
            return "c.id";
        }
        if (fieldName.compareToIgnoreCase("name") == 0) {
            return "c.name";
        }
        if (fieldName.compareToIgnoreCase("competition") == 0) {
            return "c.competition.id";
        }
        if (fieldName.compareToIgnoreCase("status") == 0) {
            return "c.status";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public TreeAdvancment getForCategory(TreeCategory treeCategory) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select treeCategory.treeAdvancment from TreeCategoryDTO as treeCategory where treeCategory.id=");
        sql.append(params.addParam(treeCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        TreeAdvancmentDTO treeAdvancmentDTO = (TreeAdvancmentDTO)((Object)TreeAdvancmentDAO.getSingleResult((Query)query));
        TreeAdvancment treeAdvancment = null;
        if (treeAdvancmentDTO != null) {
            treeAdvancment = (TreeAdvancment)this.adapterPool.create(TreeAdvancment.class, (Object)treeAdvancmentDTO);
        }
        this.flush();
        return treeAdvancment;
    }

    public List<TreeAdvancment> getActiveTreeAdvancmentsForCompetitions(Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select treeAdvancment from TreeAdvancmentDTO as treeAdvancment where treeAdvancment.status=");
        sql.append(params.addParam((Object)TreeAdvancment.Status.ACTIVE));
        sql.append(" and (select count(*) from TreeCategoryDTO as treeCategory where treeCategory.treeAdvancment.id=treeAdvancment.id and treeCategory.competition.id=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(")>0");
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<TreeAdvancment> treeAdvancments = new LinkedList<TreeAdvancment>();
        for (TreeAdvancmentDTO treeAdvancmentDTO : list) {
            treeAdvancments.add((TreeAdvancment)this.adapterPool.create(TreeAdvancment.class, (Object)treeAdvancmentDTO));
        }
        this.flush();
        return treeAdvancments;
    }

    public TreeAdvancment getActiveTreeAdvancmentByName(String name) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select treeAdvancment from TreeAdvancmentDTO as treeAdvancment where treeAdvancment.status=");
        sql.append(params.addParam((Object)TreeAdvancment.Status.ACTIVE));
        sql.append(" and treeAdvancment.name=");
        sql.append(params.addParam(name));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        TreeAdvancmentDTO treeAdvancmentDTO = (TreeAdvancmentDTO)((Object)TreeAdvancmentDAO.getSingleResult((Query)query));
        TreeAdvancment treeAdvancment = null;
        if (treeAdvancmentDTO != null) {
            treeAdvancment = (TreeAdvancment)this.adapterPool.create(TreeAdvancment.class, (Object)treeAdvancmentDTO);
        }
        this.flush();
        return treeAdvancment;
    }
}

