/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.weighing;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.web.common.CommonResponse;
import si.nevensrok.jtekma.server.web.common.weighing.CompetitorData;
import si.nevensrok.jtekma.server.web.common.weighing.CompetitorSearch;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;

@Controller
@RequestMapping(value={"/weighing"})
public class WeighingController
extends CoreController {
    @ModelAttribute(value="weighingActive")
    public Boolean getWeighingActive() {
        return Boolean.TRUE;
    }

    @RequestMapping
    public String page(HttpServletRequest request, Model model) {
        return "weighing/weighing";
    }

    @RequestMapping(value={"competitors"}, method={RequestMethod.POST})
    @ResponseBody
    public List<CompetitorData> getCompetitors(HttpServletResponse response, @RequestBody CompetitorSearch competitorSearch) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        PersonCompetitor example = new PersonCompetitor();
        example.setStatus(Competitor.Status.ACTIVE);
        example.setType(Competitor.Type.COMPETITOR);
        Page page = new Page();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        page.setFilter((Filter)rootFilter);
        rootFilter.addFilter((Filter)new ExampleFilter((Object)example));
        if (competitorSearch.getName() != null && !competitorSearch.getName().trim().isEmpty()) {
            GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
            rootFilter.addFilter((Filter)nameFilter);
            nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + competitorSearch.getName().trim() + "%")));
            nameFilter.addFilter((Filter)new FieldFilter("surname", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + competitorSearch.getName().trim() + "%")));
        }
        if (competitorSearch.getClub() != null && !competitorSearch.getClub().trim().isEmpty()) {
            rootFilter.addFilter((Filter)new FieldFilter("club.name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + competitorSearch.getClub().trim() + "%")));
        }
        page.setStartIndex(Long.valueOf(0L));
        if (competitorSearch.getDisplayPerPage() != null) {
            page.setPageRowLimitCount(Long.valueOf(competitorSearch.getDisplayPerPage().longValue()));
        }
        page.setFetchCount(false);
        page.setSort(new Sort());
        page.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        page.getSort().addField(new Sort.Field("surname", Sort.Field.Direction.ASC, false));
        page = this.getManagersList().getCompetitorManager().findForCompetition(this.getUserData().getCompetition(), page);
        LinkedList<CompetitorData> competitorDatas = new LinkedList<CompetitorData>();
        for (Competitor competitor : page.getData()) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            Club club = personCompetitor.getClub();
            LinkedList<Long> categoryDatas = new LinkedList<Long>();
            List categories = this.getManagersList().getCategoryManager().getCategoriesForCompetitor((Competitor)personCompetitor);
            for (Category category : categories) {
                categoryDatas.add(category.getCategoryId());
            }
            competitorDatas.add(new CompetitorData(personCompetitor.getCompetitorId(), personCompetitor.getName(), personCompetitor.getSurname(), club.getName(), categoryDatas, personCompetitor.getYearOfBirth(), personCompetitor.getWeight()));
        }
        return competitorDatas;
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"save-competitor"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse saveCompetitor(HttpServletResponse response, @RequestBody CompetitorData competitorData) {
        Competitor competitor = this.getManagersList().getCompetitorManager().getById(competitorData.getId());
        if (competitor != null) {
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCompetitor(competitor);
            if (!this.getUserData().getCompetition().equals((Object)competition)) {
                throw new ForbiddenException("Invalid competition for competitor");
            }
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            personCompetitor.setWeight(competitorData.getWeight());
            personCompetitor.setYearOfBirth(competitorData.getYearOfBirth());
            this.getManagersList().getCompetitorManager().updateCompetitor((Competitor)personCompetitor);
            if (competitorData.getCategories() != null) {
                HashSet<Category> categories = new HashSet<Category>();
                for (Long categoryId : competitorData.getCategories()) {
                    categories.add(new Category(categoryId));
                }
                this.getManagersList().getCompetitorManager().setCompetitorCategories((Competitor)personCompetitor, categories);
            }
            return new CommonResponse(Boolean.TRUE, "");
        }
        return new CommonResponse(Boolean.FALSE, "Competitor not found");
    }
}

