/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.automation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryCompetitorCount;
import si.nevensrok.jtekma.common.category.CategoryMatchCount;
import si.nevensrok.jtekma.common.competition.AutomationSettings;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.automation.AutomationSettingsModel;
import si.nevensrok.jtekma.server.web.controllers.automation.CategoryJson;

@Controller
@RequestMapping(value={"/automation"})
public class AutomationController
extends CoreController {
    @ModelAttribute(value="calculationIntervalOptions")
    public Map<AutomationSettings.CalculationInterval, String> getCalculationIntervalOptions(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<AutomationSettings.CalculationInterval, String> calculationIntervalOptions = new LinkedHashMap<AutomationSettings.CalculationInterval, String>();
        for (AutomationSettings.CalculationInterval calculationInterval : AutomationSettings.CalculationInterval.values()) {
            calculationIntervalOptions.put(calculationInterval, this.getLanguageText(locale, "automation.settings.calculationInterval." + calculationInterval.name()));
        }
        return calculationIntervalOptions;
    }

    @RequestMapping
    public String index(HttpServletRequest request, Model model) {
        return "redirect:/automation/settings";
    }

    @RequestMapping(value={"settings"}, method={RequestMethod.GET})
    public String settings(HttpServletRequest request, Model model, @ModelAttribute(value="automationSettings") AutomationSettingsModel automationSettingsModel, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        model.addAttribute("settingsActive", (Object)Boolean.TRUE);
        AutomationSettings automationSettings = this.getManagersList().getCompetitionManager().getAutomationSettings(this.getUserData().getCompetition());
        ObjectUtil.copyNotNullProperties((Object)automationSettings, (Object)automationSettingsModel);
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "automation.settings.text.saved"));
        }
        return "automation/settings";
    }

    @RequestMapping(value={"settings"}, method={RequestMethod.POST})
    public String settingsPost(HttpServletRequest request, Model model, @ModelAttribute(value="automationSettings") AutomationSettingsModel automationSettingsModel) {
        AutomationSettings automationSettings = this.getManagersList().getCompetitionManager().getAutomationSettings(this.getUserData().getCompetition());
        ObjectUtil.copyNotNullProperties((Object)automationSettingsModel, (Object)automationSettings);
        this.getManagersList().getCompetitionManager().setAutomationSettings(this.getUserData().getCompetition(), automationSettings);
        return "redirect:/automation/settings?messageCode=1";
    }

    @RequestMapping(value={"categories"}, method={RequestMethod.GET})
    public String categories(HttpServletRequest request, Model model, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) throws Exception {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        model.addAttribute("categoriesActive", (Object)Boolean.TRUE);
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "automation.categories.text.saved"));
        }
        List categoriesForAutomation = this.getManagersList().getCategoryManager().getCategoriesForAutomation(this.getUserData().getCompetition());
        ArrayList allCategories = new ArrayList(this.getManagersList().getCategoryManager().getActiveCategoriesForCompetition(this.getUserData().getCompetition()));
        Collections.sort(allCategories, new Comparator<Category>(){

            @Override
            public int compare(Category o1, Category o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        LinkedList<CategoryJson> jsonCategories = new LinkedList<CategoryJson>();
        Map competitorCount = this.getManagersList().getCategoryManager().getCategoryCompetitorCount(new HashSet(allCategories));
        Map matchCount = this.getManagersList().getCategoryManager().getCategoryMatchCount(new HashSet(allCategories));
        Map tatamis = this.getManagersList().getTatamiManager().getTatamisForCategories(new HashSet(allCategories));
        for (Category category : allCategories) {
            CategoryJson categoryJson = new CategoryJson();
            jsonCategories.add(categoryJson);
            categoryJson.setId(category.getCategoryId());
            categoryJson.setName(category.getName());
            categoryJson.setType(this.getLanguageText(locale, "categories.type." + category.getType().name()));
            categoryJson.setCompetitorCount(((CategoryCompetitorCount)competitorCount.get(category)).getAllCompetitors());
            CategoryMatchCount categoryMatchCount = (CategoryMatchCount)matchCount.get(category);
            categoryJson.setMatchCount(new CategoryJson.MatchCount());
            categoryJson.getMatchCount().setFinishedMatches(categoryMatchCount.getFinishedMatches());
            categoryJson.getMatchCount().setNeededMatches(categoryMatchCount.getNeededMatches());
            categoryJson.getMatchCount().setTotalMatches(categoryMatchCount.getTotalMatches());
            if (categoryMatchCount.getNeededMatches() == 0) {
                categoryJson.setStatus(this.getLanguageText(locale, "automation.categories.status.FINISHED"));
                categoryJson.setStatusLabel("success");
            } else if (categoryMatchCount.getFinishedMatches() > 0) {
                categoryJson.setStatus(this.getLanguageText(locale, "automation.categories.status.INPROGRESS"));
                categoryJson.setStatusLabel("warning");
            } else {
                categoryJson.setStatus(this.getLanguageText(locale, "automation.categories.status.WAITING"));
                categoryJson.setStatusLabel("danger");
            }
            categoryJson.setTatamis(new LinkedList<String>());
            for (Tatami tatami : (Set)tatamis.get(category)) {
                categoryJson.getTatamis().add(tatami.getName());
            }
            Integer order = null;
            int n = 0;
            for (Category c : categoriesForAutomation) {
                ++n;
                if (!c.equals((Object)category)) continue;
                order = n;
                break;
            }
            categoryJson.setOrder(order);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString(jsonCategories);
        model.addAttribute("categories", (Object)json);
        return "automation/categories";
    }

    @RequestMapping(value={"categories"}, method={RequestMethod.POST})
    public String categoriesPost(HttpServletRequest request, Model model, @RequestParam(value="categoryOrder") String categoryOrder) {
        String[] categoryIds = categoryOrder.split(",");
        HashMap<Category, Integer> categoryAutomationOrder = new HashMap<Category, Integer>();
        for (int i = 0; i < categoryIds.length; ++i) {
            Category category = new Category();
            category.setCategoryId(Long.valueOf(Long.parseLong(categoryIds[i])));
            Competition competitionForCategory = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
            if (!this.getUserData().getCompetition().equals((Object)competitionForCategory)) {
                throw new RuntimeException("Invalid competition");
            }
            categoryAutomationOrder.put(category, i + 1);
        }
        this.getManagersList().getCategoryManager().setCategoryAutomationOrder(this.getUserData().getCompetition(), categoryAutomationOrder);
        return "redirect:/automation/categories?messageCode=1";
    }
}

