/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import si.nevensrok.common.remoting.hazelcast.MethodExecutionResult;
import si.nevensrok.common.remoting.hazelcast.ServiceExporter;
import si.nevensrok.common.remoting.hazelcast.ServiceRepository;

public class MethodExecutionCallable
implements Callable<MethodExecutionResult>,
HazelcastInstanceAware,
Serializable {
    private static final long serialVersionUID = 1869946657542839849L;
    private transient HazelcastInstance hazelcastInstance;
    private String className;
    private String version;
    private String methodName;
    private Class<?>[] parameterTypes;
    private Object[] arguments;

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public MethodExecutionCallable(String className, String version, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        this.className = className;
        this.version = version;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    @Override
    public MethodExecutionResult call() throws Exception {
        ServiceRepository serviceRepository = ServiceRepository.getServiceRepositoryForUuid(this.hazelcastInstance.getCluster().getLocalMember().getUuid());
        if (serviceRepository == null) {
            throw new RuntimeException("ServiceRepository not found");
        }
        ServiceExporter serviceExporter = serviceRepository.getServiceExporterFor(this.className, this.version);
        if (serviceExporter == null) {
            throw new RuntimeException("ServiceExporter not found");
        }
        MethodExecutionResult methodExecutionResult = new MethodExecutionResult();
        try {
            Object result = serviceExporter.getHazelcastInvokerServiceExporter().invoke(this.methodName, this.parameterTypes, this.arguments);
            methodExecutionResult.setResult(result);
        }
        catch (InvocationTargetException e) {
            methodExecutionResult.setThrowable(e.getCause());
        }
        return methodExecutionResult;
    }
}

