/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.dl.CoreDao;
import si.nevensrok.common.dl.Dto;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterPool;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.common.dl.query.Sort;

public abstract class ExtendedDao<P, DTO extends Dto<P>, POJO extends Pojo<P>>
extends CoreDao
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ExtendedDao.class);
    private static final int databaseLockRetries = 10;
    private static final int databaseLockTimeout = 5;
    protected Class<DTO> dtoClass;
    protected Class<POJO> pojoClass;
    protected DatabaseAdapterPool adapterPool;

    protected abstract String getTableFieldName(String var1);

    public ExtendedDao(Class<DTO> dtoClass, Class<POJO> pojoClass) {
        this.dtoClass = dtoClass;
        this.pojoClass = pojoClass;
    }

    public void setDatabaseAdapterPool(DatabaseAdapterPool adapterPool) {
        this.adapterPool = adapterPool;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.adapterPool == null) {
            throw new IllegalArgumentException("Property 'adapterPool' is requied");
        }
        super.afterPropertiesSet();
    }

    public POJO create(POJO inst) {
        Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                dto = (Dto)super.createInstance(dto);
                inst.setId(dto.getId());
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                log.trace("Database deadlock detected", (Throwable)e);
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error creating instance");
        }
        return inst;
    }

    public List<POJO> createList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
            dto = (Dto)super.createInstance(dto);
            inst.setId(dto.getId());
        }
        this.flush();
        return instList;
    }

    public POJO save(POJO inst) {
        Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                dto = (Dto)super.saveInstance(dto);
                inst.setId(dto.getId());
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                log.trace("Database deadlock detected", (Throwable)e);
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error saving instance");
        }
        return inst;
    }

    public List<POJO> saveList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
            dto = (Dto)super.saveInstance(dto);
            inst.setId(dto.getId());
        }
        this.flush();
        return instList;
    }

    public POJO update(POJO inst) {
        Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                super.updateInstance(dto);
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                log.trace("Database deadlock detected", (Throwable)e);
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error updating instance");
        }
        return inst;
    }

    public List<POJO> updateList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
            super.updateInstance(dto);
        }
        this.flush();
        return instList;
    }

    public void delete(POJO inst) {
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
                super.deleteInstance(dto);
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                log.trace("Database deadlock detected", (Throwable)e);
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error deleting instance");
        }
    }

    public void deleteList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.adapterPool.create(this.dtoClass, inst);
            super.deleteInstance(dto);
        }
        this.flush();
    }

    protected void addSort(StringBuilder sqlQuery, Sort sort) {
        if (sort == null) {
            return;
        }
        boolean first = true;
        for (Sort.Field sortField : sort.getFieldList()) {
            if (first) {
                first = false;
                sqlQuery.append(" order by");
            } else {
                sqlQuery.append(",");
            }
            sqlQuery.append(" ");
            if (!sortField.isCaseSensitive()) {
                sqlQuery.append("UPPER(" + this.getTableFieldName(sortField.getFieldName()) + ")");
            } else {
                sqlQuery.append(this.getTableFieldName(sortField.getFieldName()));
            }
            if (sortField.getDirection().compareTo((Enum)Sort.Field.Direction.DESC) != 0) continue;
            sqlQuery.append(" desc");
        }
    }

    protected void addFilter(StringBuilder sqlQuery, ParamsBinder params, Filter filter) throws Exception {
        this.addFilter(sqlQuery, params, filter, true);
    }

    protected void addFilter(StringBuilder sqlQuery, ParamsBinder params, Filter filter, boolean caseSensitive) throws Exception {
        if (filter == null) {
            return;
        }
        if (filter instanceof ExampleFilter) {
            ExampleFilter exampleFilter = (ExampleFilter)filter;
            this.adapterPool.applyFilterByExample(this.dtoClass, sqlQuery, params, exampleFilter.getExample(), caseSensitive);
        } else if (filter instanceof FieldFilter) {
            FieldFilter fieldFilter = (FieldFilter)filter;
            sqlQuery.append(" ");
            if (fieldFilter.getComparator() == FieldFilter.Comparator.LIKECASEISENSITIVE) {
                sqlQuery.append("UPPER(" + this.getTableFieldName(fieldFilter.getFieldName()) + ")");
            } else {
                sqlQuery.append(this.getTableFieldName(fieldFilter.getFieldName()));
            }
            switch (fieldFilter.getComparator()) {
                case EQUAL: {
                    sqlQuery.append("=");
                    break;
                }
                case NOTEQUAL: {
                    sqlQuery.append("!=");
                    break;
                }
                case LESS: {
                    sqlQuery.append("<");
                    break;
                }
                case LESSOREQUAL: {
                    sqlQuery.append("<=");
                    break;
                }
                case MORE: {
                    sqlQuery.append(">");
                    break;
                }
                case MOREOREQUAL: {
                    sqlQuery.append(">=");
                    break;
                }
                case LIKE: {
                    sqlQuery.append(" like ");
                    break;
                }
                case LIKECASEISENSITIVE: {
                    sqlQuery.append(" like ");
                    break;
                }
                case ISNULL: {
                    sqlQuery.append(" is null");
                    break;
                }
                case ISNOTNULL: {
                    sqlQuery.append(" is not null");
                    break;
                }
                case IN: {
                    sqlQuery.append(" in ");
                    break;
                }
                case NOTIN: {
                    sqlQuery.append(" not in ");
                }
            }
            if (fieldFilter.getComparator() != FieldFilter.Comparator.ISNULL && fieldFilter.getComparator() != FieldFilter.Comparator.ISNOTNULL) {
                if (fieldFilter.getComparator() == FieldFilter.Comparator.LIKECASEISENSITIVE) {
                    sqlQuery.append("UPPER(" + params.addParam(fieldFilter.getValue()) + ")");
                } else {
                    sqlQuery.append(params.addParam(fieldFilter.getValue()));
                }
            }
        } else if (filter instanceof GroupFilter) {
            StringBuilder subQuery = new StringBuilder();
            GroupFilter groupFilter = (GroupFilter)filter;
            boolean first = true;
            for (Filter subFilter : groupFilter.getFilters()) {
                StringBuilder filterQuery = new StringBuilder();
                this.addFilter(filterQuery, params, subFilter, caseSensitive);
                if (filterQuery.length() == 0) continue;
                if (first) {
                    first = false;
                } else if (groupFilter.getCombining().compareTo((Enum)GroupFilter.Combine.AND) == 0) {
                    subQuery.append(" and");
                } else {
                    subQuery.append(" or");
                }
                subQuery.append((CharSequence)filterQuery);
            }
            if (subQuery.length() > 0) {
                sqlQuery.append(" (");
                sqlQuery.append((CharSequence)subQuery);
                sqlQuery.append(")");
            }
        }
    }

    public POJO getById(P id) {
        Dto dto = (Dto)this.getCurrentSession().get(this.dtoClass, (Serializable)id);
        Pojo pojo = null;
        if (dto != null) {
            pojo = (Pojo)this.adapterPool.create(this.pojoClass, dto);
        }
        this.flush();
        return (POJO)pojo;
    }

    public Page<POJO> find(Page<POJO> page) {
        return this.find(page, true);
    }

    public Page<POJO> find(Page<POJO> page, boolean caseSensitive) {
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("from " + this.dtoClass.getName() + " as c");
        ParamsBinder params = new ParamsBinder();
        if (page.getFilter() != null) {
            StringBuilder filterQuery = new StringBuilder();
            try {
                this.addFilter(filterQuery, params, page.getFilter(), caseSensitive);
            }
            catch (Exception e) {
                log.error("Error adding filters", (Throwable)e);
            }
            if (filterQuery.length() > 0) {
                sqlQuery.append(" where");
                sqlQuery.append((CharSequence)filterQuery);
            }
        }
        Long totalRowCount = 0L;
        if (page.isFetchCount()) {
            Query<?> query = this.createQuery("select count(c) " + sqlQuery.toString());
            params.bindParams(query);
            totalRowCount = (Long)query.getSingleResult();
        }
        LinkedList<Pojo> list = new LinkedList<Pojo>();
        if (page.isFetchList()) {
            try {
                this.addSort(sqlQuery, page.getSort());
            }
            catch (Exception e) {
                log.error("Error adding sort conditions", (Throwable)e);
            }
            Query<?> query = this.createQuery("select c " + sqlQuery.toString());
            params.bindParams(query);
            if (page.getStartIndex() != null) {
                query.setFirstResult(page.getStartIndex().intValue());
            }
            if (page.getPageRowLimitCount() != null) {
                query.setMaxResults(page.getPageRowLimitCount().intValue());
            }
            List result = query.getResultList();
            for (Object item : result) {
                Dto dto = (Dto)item;
                Pojo pojo = (Pojo)this.adapterPool.create(this.pojoClass, dto);
                list.add(pojo);
            }
        }
        Page returnPage = new Page();
        returnPage.setData(list);
        returnPage.setTotalRowCount(totalRowCount);
        this.flush();
        return returnPage;
    }
}

