/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class ConcurrentSessionFilter
extends GenericFilterBean {
    private SessionRegistry sessionRegistry;
    private String expiredUrl;
    private LogoutHandler[] handlers = new LogoutHandler[]{new SecurityContextLogoutHandler()};
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public ConcurrentSessionFilter(SessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, (String)"SessionRegistry required");
        this.sessionRegistry = sessionRegistry;
    }

    public ConcurrentSessionFilter(SessionRegistry sessionRegistry, String expiredUrl) {
        Assert.notNull((Object)sessionRegistry, (String)"SessionRegistry required");
        Assert.isTrue((expiredUrl == null || UrlUtils.isValidRedirectUrl(expiredUrl) ? 1 : 0) != 0, (String)(expiredUrl + " isn't a valid redirect URL"));
        this.sessionRegistry = sessionRegistry;
        this.expiredUrl = expiredUrl;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sessionRegistry, (String)"SessionRegistry required");
        Assert.isTrue((this.expiredUrl == null || UrlUtils.isValidRedirectUrl(this.expiredUrl) ? 1 : 0) != 0, (String)(this.expiredUrl + " isn't a valid redirect URL"));
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        SessionInformation info;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession(false);
        if (session != null && (info = this.sessionRegistry.getSessionInformation(session.getId())) != null) {
            if (info.isExpired()) {
                this.doLogout(request, response);
                String targetUrl = this.determineExpiredUrl(request, info);
                if (targetUrl != null) {
                    this.redirectStrategy.sendRedirect(request, response, targetUrl);
                    return;
                }
                response.getWriter().print("This session has been expired (possibly due to multiple concurrent logins being attempted as the same user).");
                response.flushBuffer();
                return;
            }
            this.sessionRegistry.refreshLastRequest(info.getSessionId());
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String determineExpiredUrl(HttpServletRequest request, SessionInformation info) {
        return this.expiredUrl;
    }

    private void doLogout(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        for (LogoutHandler handler : this.handlers) {
            handler.logout(request, response, auth);
        }
    }

    public void setLogoutHandlers(LogoutHandler[] handlers) {
        Assert.notNull((Object)handlers);
        this.handlers = handlers;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }
}

