/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageReceiver;
import si.nevensrok.common.network.udp.MessageReceiver;

public class UdpMessageReceiver
implements NetworkMessageReceiver,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UdpMessageReceiver.class);
    private Integer port;
    private int bufferSize = 65536;
    private DatagramSocket socket = null;
    private MessageReceiver messageReceiver;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Integer getLocalPort() {
        return this.socket.getLocalPort();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            if (this.port == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Connecting to UDP on random port");
                }
                this.socket = new DatagramSocket();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Connecting to UDP on port {}", (Object)this.port);
                }
                this.socket = new DatagramSocket(this.port);
            }
            this.messageReceiver = new MessageReceiver(this.socket, this.bufferSize);
        }
        catch (Exception e) {
            try {
                this.messageReceiver.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new NetworkException("Error connecting to broadcast", e);
        }
    }

    public void destroy() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Disconnecting from UDP on port {}", (Object)this.port);
        }
        try {
            this.messageReceiver.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    @Override
    public NetworkMessage receiveMessage() throws NetworkException {
        return this.messageReceiver.getNextMessage();
    }
}

