/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ehcache.common;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ehcache.common.CacheEventMessage;
import si.nevensrok.common.ehcache.tcp.TcpCacheReplicator;

public abstract class AbstractCacheReplicator
implements CacheReplicator {
    private static final Logger log = LoggerFactory.getLogger(TcpCacheReplicator.class);
    private boolean replicateUpdatesViaCopy = true;
    private boolean enabled = true;

    public abstract void sendCacheEventMessage(Ehcache var1, CacheEventMessage var2);

    public abstract Object clone() throws CloneNotSupportedException;

    public boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public void setReplicateUpdatesViaCopy(boolean replicateUpdatesViaCopy) {
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!element.isKeySerializable()) {
            log.warn("Key {} is not Serializable and cannot be replicated", element.getObjectKey());
            return;
        }
        this.sendCacheEventMessage(cache, new CacheEventMessage(CacheEventMessage.Action.REMOVE, element.getObjectKey(), null, cache.getName()));
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!element.isKeySerializable()) {
            log.warn("Key {} is not Serializable and cannot be replicated", element.getObjectKey());
            return;
        }
        if (!element.isSerializable()) {
            log.warn("Object with key {} is not Serializable and cannot be replicated", element.getObjectKey());
            return;
        }
        this.sendCacheEventMessage(cache, new CacheEventMessage(CacheEventMessage.Action.PUT, element.getObjectKey(), element, cache.getName()));
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!element.isKeySerializable()) {
            log.warn("Key {} is not Serializable and cannot be replicated", element.getObjectKey());
            return;
        }
        if (!element.isSerializable()) {
            log.warn("Object with key {} is not Serializable and cannot be replicated", element.getObjectKey());
            return;
        }
        if (this.isReplicateUpdatesViaCopy()) {
            this.sendCacheEventMessage(cache, new CacheEventMessage(CacheEventMessage.Action.PUT, element.getObjectKey(), element, cache.getName()));
        } else {
            this.sendCacheEventMessage(cache, new CacheEventMessage(CacheEventMessage.Action.REMOVE, element.getObjectKey(), null, cache.getName()));
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.notAlive()) {
            return;
        }
        this.sendCacheEventMessage(cache, new CacheEventMessage(CacheEventMessage.Action.REMOVE_ALL, null, null, cache.getName()));
    }

    public void dispose() {
        this.enabled = false;
    }

    public boolean notAlive() {
        return !this.enabled;
    }

    public boolean alive() {
        return this.enabled;
    }
}

