/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.tcp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.cache.ClearCacheMessage;
import si.nevensrok.common.cache.EvictCacheMessage;
import si.nevensrok.common.cache.PutCacheMessage;
import si.nevensrok.common.cache.tcp.TcpCache;
import si.nevensrok.common.cache.tcp.TcpCacheManager;
import si.nevensrok.common.network.NetworkException;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageReceiver;

public class CacheMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(CacheMessageHandler.class);

    public CacheMessageHandler(final TcpCacheManager tcpCacheManager, final NetworkMessageReceiver networkMessageReceiver) {
        Thread thread = new Thread("Cache message thread"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            TcpCache tcpCache;
                            NetworkMessage networkMessage = networkMessageReceiver.receiveMessage();
                            Object object = networkMessage.getData();
                            log.trace("Cache message received: {}", object);
                            if (object == null) {
                                return;
                            }
                            if (object instanceof PutCacheMessage) {
                                PutCacheMessage putCacheMessage = (PutCacheMessage)object;
                                tcpCache = tcpCacheManager.getCache(putCacheMessage.getCacheName());
                                tcpCache.addCache(putCacheMessage.getKey(), putCacheMessage.getCachedValue());
                                continue;
                            }
                            if (object instanceof EvictCacheMessage) {
                                EvictCacheMessage evictMessage = (EvictCacheMessage)object;
                                tcpCache = tcpCacheManager.getCache(evictMessage.getCacheName());
                                tcpCache.evictCache(evictMessage.getKey());
                                continue;
                            }
                            if (object instanceof ClearCacheMessage) {
                                ClearCacheMessage clearCacheMessage = (ClearCacheMessage)object;
                                tcpCache = tcpCacheManager.getCache(clearCacheMessage.getCacheName());
                                tcpCache.clearCache();
                                continue;
                            }
                            log.debug("Unsupported message type: {}", (Object)object.getClass().getName());
                        }
                    }
                    catch (NetworkException e) {
                    }
                    catch (Throwable e) {
                        log.error("Error processing cache message", e);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

