/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.EnableGlobalAuthentication;
import org.springframework.security.config.annotation.authentication.configuration.InitializeAuthenticationProviderBeanManagerConfigurer;
import org.springframework.security.config.annotation.authentication.configuration.InitializeUserDetailsBeanManagerConfigurer;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

@Configuration
public class AuthenticationConfiguration {
    private AtomicBoolean buildingAuthenticationManager = new AtomicBoolean();
    private ApplicationContext applicationContext;
    private AuthenticationManager authenticationManager;
    private boolean authenticationManagerInitialized;
    private List<GlobalAuthenticationConfigurerAdapter> globalAuthConfigurers = Collections.emptyList();
    private ObjectPostProcessor<Object> objectPostProcessor;

    @Bean
    public AuthenticationManagerBuilder authenticationManagerBuilder(ObjectPostProcessor<Object> objectPostProcessor) {
        return new AuthenticationManagerBuilder(objectPostProcessor);
    }

    @Bean
    public static GlobalAuthenticationConfigurerAdapter enableGlobalAuthenticationAutowiredConfigurer(ApplicationContext context) {
        return new EnableGlobalAuthenticationAutowiredConfigurer(context);
    }

    @Bean
    public static InitializeUserDetailsBeanManagerConfigurer initializeUserDetailsBeanManagerConfigurer(ApplicationContext context) {
        return new InitializeUserDetailsBeanManagerConfigurer(context);
    }

    @Bean
    public static InitializeAuthenticationProviderBeanManagerConfigurer initializeAuthenticationProviderBeanManagerConfigurer(ApplicationContext context) {
        return new InitializeAuthenticationProviderBeanManagerConfigurer(context);
    }

    public AuthenticationManager getAuthenticationManager() throws Exception {
        if (this.authenticationManagerInitialized) {
            return this.authenticationManager;
        }
        AuthenticationManagerBuilder authBuilder = this.authenticationManagerBuilder(this.objectPostProcessor);
        if (this.buildingAuthenticationManager.getAndSet(true)) {
            return new AuthenticationManagerDelegator(authBuilder);
        }
        for (GlobalAuthenticationConfigurerAdapter config : this.globalAuthConfigurers) {
            authBuilder.apply(config);
        }
        this.authenticationManager = (AuthenticationManager)authBuilder.build();
        if (this.authenticationManager == null) {
            this.authenticationManager = this.getAuthenticationManagerBean();
        }
        this.authenticationManagerInitialized = true;
        return this.authenticationManager;
    }

    @Autowired(required=false)
    public void setGlobalAuthenticationConfigurers(List<GlobalAuthenticationConfigurerAdapter> configurers) throws Exception {
        Collections.sort(configurers, AnnotationAwareOrderComparator.INSTANCE);
        this.globalAuthConfigurers = configurers;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired
    public void setObjectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        this.objectPostProcessor = objectPostProcessor;
    }

    private <T> T lazyBean(Class<T> interfaceName) {
        LazyInitTargetSource lazyTargetSource = new LazyInitTargetSource();
        String[] beanNamesForType = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, interfaceName);
        if (beanNamesForType.length == 0) {
            return null;
        }
        Assert.isTrue((beanNamesForType.length == 1 ? 1 : 0) != 0, (String)("Expecting to only find a single bean for type " + interfaceName + ", but found " + Arrays.asList(beanNamesForType)));
        lazyTargetSource.setTargetBeanName(beanNamesForType[0]);
        lazyTargetSource.setBeanFactory((BeanFactory)this.applicationContext);
        ProxyFactoryBean proxyFactory = new ProxyFactoryBean();
        proxyFactory = this.objectPostProcessor.postProcess(proxyFactory);
        proxyFactory.setTargetSource((TargetSource)lazyTargetSource);
        return (T)proxyFactory.getObject();
    }

    private AuthenticationManager getAuthenticationManagerBean() {
        return this.lazyBean(AuthenticationManager.class);
    }

    static final class AuthenticationManagerDelegator
    implements AuthenticationManager {
        private AuthenticationManagerBuilder delegateBuilder;
        private AuthenticationManager delegate;
        private final Object delegateMonitor = new Object();

        AuthenticationManagerDelegator(AuthenticationManagerBuilder delegateBuilder) {
            Assert.notNull((Object)delegateBuilder, (String)"delegateBuilder cannot be null");
            this.delegateBuilder = delegateBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.delegate != null) {
                return this.delegate.authenticate(authentication);
            }
            Object object = this.delegateMonitor;
            synchronized (object) {
                if (this.delegate == null) {
                    this.delegate = (AuthenticationManager)this.delegateBuilder.getObject();
                    this.delegateBuilder = null;
                }
            }
            return this.delegate.authenticate(authentication);
        }

        public String toString() {
            return "AuthenticationManagerDelegator [delegate=" + this.delegate + "]";
        }
    }

    private static class EnableGlobalAuthenticationAutowiredConfigurer
    extends GlobalAuthenticationConfigurerAdapter {
        private final ApplicationContext context;
        private static final Log logger = LogFactory.getLog(EnableGlobalAuthenticationAutowiredConfigurer.class);

        public EnableGlobalAuthenticationAutowiredConfigurer(ApplicationContext context) {
            this.context = context;
        }

        @Override
        public void init(AuthenticationManagerBuilder auth) {
            Map beansWithAnnotation = this.context.getBeansWithAnnotation(EnableGlobalAuthentication.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Eagerly initializing " + beansWithAnnotation));
            }
        }
    }
}

