/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.EventManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class TatamiFightsManagerImpl
implements TatamiFightsManager {
    private static final Logger log = LoggerFactory.getLogger(TatamiFightsManagerImpl.class);
    private Set<Long> lockedTatamis = new HashSet<Long>();
    private TatamiManager tatamiManager;
    private CategoryManager categoryManager;
    private MatchManager matchManager;
    private EventManager eventManager;

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMatchToTatami(Match match, Tatami tatami) {
        boolean added = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return added;
        }
        if (match == null || match.getMatchId() == null) {
            return added;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding match {} to tatami {}", (Object)match, (Object)tatami);
        }
        try {
            match = this.matchManager.getById(match.getMatchId());
            Category category = this.categoryManager.getCategoryForMatch(match);
            if (this.tatamiManager.isCategoryOnTatami(tatami, category)) {
                if (this.tatamiManager.getTatamiForMatch(match) == null) {
                    if (match.getStatus() == Match.Status.WAITING) {
                        ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
                        FightOrder fightOrder = new FightOrder();
                        fightOrder.setTatami(tatami);
                        fightOrder.setMatch(match);
                        fightOrder.setFightNumber(Integer.valueOf(fights.size() + 1));
                        fights.add(fightOrder);
                        this.checkList(fights);
                        this.tatamiManager.setFightOrderForTatami(tatami, fights);
                        this.matchManager.setMatchStatus(match, Match.Status.INQUEUE);
                        added = true;
                    } else if (log.isDebugEnabled()) {
                        log.debug("Match {} has invalid status", (Object)match);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Match {} is already on tatami", (Object)tatami);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Category {} is not on tatami {}", (Object)category, (Object)tatami);
            }
        }
        catch (Throwable e) {
            log.error("Error while adding match to tatami", e);
            added = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMatchFromTatami(Match match, Tatami tatami) {
        boolean removed = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return removed;
        }
        if (match == null || match.getMatchId() == null) {
            return removed;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Removing match {} from tatami {}", (Object)match, (Object)tatami);
        }
        try {
            match = this.matchManager.getById(match.getMatchId());
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : new LinkedList(fights)) {
                if (fightOrder.getMatch() != null && fightOrder.getMatch().getMatchId().equals(match.getMatchId())) {
                    fights.remove(fightOrder);
                    removed = true;
                    continue;
                }
                if (!removed) continue;
                fightOrder.setFightNumber(Integer.valueOf(fightOrder.getFightNumber() - 1));
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
            if (match.getStatus() == Match.Status.INQUEUE || match.getStatus() == Match.Status.INPROGRESS) {
                this.matchManager.setMatchStatus(match, Match.Status.WAITING);
            }
        }
        catch (Throwable e) {
            log.error("Error while removeing match from tatami", e);
            removed = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMatchOnTatamiUp(Match match, Tatami tatami) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (match == null || match.getMatchId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving up match {} on tatami {}", (Object)match, (Object)tatami);
        }
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 1; i < fights.size(); ++i) {
                if (((FightOrder)fights.get(i)).getMatch() == null || !fights.get(i).getMatch().getMatchId().equals(match.getMatchId())) continue;
                fights.get(i).setFightNumber(Integer.valueOf(fights.get(i).getFightNumber() - 1));
                fights.get(i - 1).setFightNumber(Integer.valueOf(fights.get(i - 1).getFightNumber() + 1));
                moved = true;
                break;
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while moving match up on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMatchOnTatamiDown(Match match, Tatami tatami) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (match == null || match.getMatchId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving down match {} on tatami {}", (Object)match, (Object)tatami);
        }
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 0; i < fights.size() - 1; ++i) {
                if (((FightOrder)fights.get(i)).getMatch() == null || !fights.get(i).getMatch().getMatchId().equals(match.getMatchId())) continue;
                fights.get(i).setFightNumber(Integer.valueOf(fights.get(i).getFightNumber() + 1));
                fights.get(i + 1).setFightNumber(Integer.valueOf(fights.get(i + 1).getFightNumber() - 1));
                moved = true;
                break;
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while moving match down on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveMatchOnTatamiToSpot(Match match, Tatami tatami, Integer moveToSpot) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (match == null || match.getMatchId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving match {} to spot {} on tatami {}", new Object[]{match, moveToSpot, tatami});
        }
        try {
            int i;
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            moveToSpot = moveToSpot - 1;
            int currentSpot = -1;
            FightOrder fightOrder = null;
            for (i = 0; i < fights.size(); ++i) {
                if (((FightOrder)fights.get(i)).getMatch() == null || !fights.get(i).getMatch().getMatchId().equals(match.getMatchId())) continue;
                currentSpot = i;
                fightOrder = fights.remove(i);
                break;
            }
            if (fightOrder != null) {
                if (moveToSpot <= currentSpot) {
                    fights.add(moveToSpot, fightOrder);
                } else {
                    fights.add(moveToSpot - 1, fightOrder);
                }
                for (i = 0; i < fights.size(); ++i) {
                    fights.get(i).setFightNumber(Integer.valueOf(i + 1));
                }
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while moving match to custom spot on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventToTatami(Event event, Tatami tatami) {
        boolean added = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return added;
        }
        if (event == null) {
            return added;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding event {} to tatami {}", (Object)event, (Object)tatami);
        }
        try {
            event.setTatami(tatami);
            event = this.eventManager.createEvent(event);
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            FightOrder fightOrder = new FightOrder();
            fightOrder.setTatami(tatami);
            fightOrder.setEvent(event);
            fightOrder.setFightNumber(Integer.valueOf(fights.size() + 1));
            fights.add(fightOrder);
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
            added = true;
        }
        catch (Throwable e) {
            log.error("Error while adding event to tatami", e);
            added = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEventFromTatami(Event event, Tatami tatami) {
        boolean removed = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return removed;
        }
        if (event == null || event.getEventId() == null) {
            return removed;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Removing event {} from tatami {}", (Object)event, (Object)tatami);
        }
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : new LinkedList(fights)) {
                if (fightOrder.getEvent() != null && fightOrder.getEvent().getEventId().equals(event.getEventId())) {
                    fights.remove(fightOrder);
                    removed = true;
                    continue;
                }
                if (!removed) continue;
                fightOrder.setFightNumber(Integer.valueOf(fightOrder.getFightNumber() - 1));
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while removeing event from tatami", e);
            removed = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveEventOnTatamiUp(Event event, Tatami tatami) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (event == null || event.getEventId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving up event {} on tatami {}", (Object)event, (Object)tatami);
        }
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 1; i < fights.size(); ++i) {
                if (((FightOrder)fights.get(i)).getEvent() == null || !fights.get(i).getEvent().getEventId().equals(event.getEventId())) continue;
                fights.get(i).setFightNumber(Integer.valueOf(fights.get(i).getFightNumber() - 1));
                fights.get(i - 1).setFightNumber(Integer.valueOf(fights.get(i - 1).getFightNumber() + 1));
                moved = true;
                break;
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while moving event up on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveEventOnTatamiDown(Event event, Tatami tatami) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (event == null || event.getEventId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving down event {} on tatami {}", (Object)event, (Object)tatami);
        }
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            for (int i = 0; i < fights.size() - 1; ++i) {
                if (((FightOrder)fights.get(i)).getEvent() == null || !fights.get(i).getEvent().getEventId().equals(event.getEventId())) continue;
                fights.get(i).setFightNumber(Integer.valueOf(fights.get(i).getFightNumber() + 1));
                fights.get(i + 1).setFightNumber(Integer.valueOf(fights.get(i + 1).getFightNumber() - 1));
                moved = true;
                break;
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while moving event down on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveEventOnTatamiToSpot(Event event, Tatami tatami, Integer moveToSpot) {
        boolean moved = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return moved;
        }
        if (event == null || event.getEventId() == null) {
            return moved;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving event {} to spot {} on tatami {}", new Object[]{event, moveToSpot, tatami});
        }
        try {
            int i;
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            moveToSpot = moveToSpot - 1;
            int currentSpot = -1;
            FightOrder fightOrder = null;
            for (i = 0; i < fights.size(); ++i) {
                if (((FightOrder)fights.get(i)).getEvent() == null || !fights.get(i).getEvent().getEventId().equals(event.getEventId())) continue;
                currentSpot = i;
                fightOrder = fights.remove(i);
                break;
            }
            if (fightOrder != null) {
                if (moveToSpot <= currentSpot) {
                    fights.add(moveToSpot, fightOrder);
                } else {
                    fights.add(moveToSpot - 1, fightOrder);
                }
                for (i = 0; i < fights.size(); ++i) {
                    fights.get(i).setFightNumber(Integer.valueOf(i + 1));
                }
            }
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while moving event to custom spot on tatami", e);
            moved = false;
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMatchFights(Tatami tatami) {
        if (tatami == null || tatami.getTatamiId() == null) {
            return;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Checking fights on tatami {}", (Object)tatami);
        }
        try {
            ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
            this.checkList(fights);
            this.tatamiManager.setFightOrderForTatami(tatami, fights);
        }
        catch (Throwable e) {
            log.error("Error while checking fights on tatami", e);
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
    }

    private void checkList(ArrayList<FightOrder> fights) {
        Collections.sort(fights, new Comparator<FightOrder>(){

            @Override
            public int compare(FightOrder o1, FightOrder o2) {
                return o1.getFightNumber().compareTo(o2.getFightNumber());
            }
        });
        int n = 1;
        for (FightOrder fightOrder : new LinkedList<FightOrder>(fights)) {
            if (fightOrder.getMatch() != null && (fightOrder.getMatch().getStatus() == Match.Status.FINISHED || fightOrder.getMatch().getNotNeeded().booleanValue())) {
                fights.remove(fightOrder);
                continue;
            }
            if (fightOrder.getEvent() != null && fightOrder.getEvent().getAutoRemove().booleanValue() && n == 1) {
                fights.remove(fightOrder);
                continue;
            }
            if (fightOrder.getMatch() != null && fightOrder.getMatch().getStatus() == Match.Status.INPROGRESS && n != 1) {
                this.matchManager.setMatchStatus(fightOrder.getMatch(), Match.Status.INQUEUE);
            }
            fightOrder.setFightNumber(Integer.valueOf(n++));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match getNextMatchForTatami(Tatami tatami) {
        if (tatami == null || tatami.getTatamiId() == null) {
            return null;
        }
        Match match = null;
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Checking fights on tatami {}", (Object)tatami);
        }
        try {
            List fights = this.tatamiManager.getFightOrderForTatami(tatami);
            if (!fights.isEmpty() && (match = ((FightOrder)fights.get(0)).getMatch()) != null) {
                this.matchManager.setMatchStatus(match, Match.Status.INPROGRESS);
                match.setStatus(Match.Status.INPROGRESS);
            }
        }
        catch (Throwable e) {
            log.error("Error while getting next match", e);
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextMatchForTatami(Tatami tatami, Match match) {
        boolean isNext = false;
        if (tatami == null || tatami.getTatamiId() == null) {
            return isNext;
        }
        if (match == null || match.getMatchId() == null) {
            return isNext;
        }
        Set<Long> set = this.lockedTatamis;
        synchronized (set) {
            while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                try {
                    this.lockedTatamis.wait();
                }
                catch (Exception exception) {}
            }
            this.lockedTatamis.add(tatami.getTatamiId());
        }
        if (log.isDebugEnabled()) {
            log.debug("Checking fights on tatami {}", (Object)tatami);
        }
        try {
            List fights = this.tatamiManager.getFightOrderForTatami(tatami);
            if (!fights.isEmpty()) {
                Match nextMatch = ((FightOrder)fights.get(0)).getMatch();
                if (match.getMatchId().equals(nextMatch.getMatchId())) {
                    this.matchManager.setMatchStatus(match, Match.Status.INPROGRESS);
                    isNext = true;
                }
            }
        }
        catch (Throwable e) {
            log.error("Error while chekings next match", e);
        }
        set = this.lockedTatamis;
        synchronized (set) {
            this.lockedTatamis.remove(tatami.getTatamiId());
            this.lockedTatamis.notifyAll();
        }
        return isNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatchesForCategory(Category category) {
        LinkedHashSet<Category> categories = new LinkedHashSet<Category>();
        categories.add(category);
        for (Tatami tatami : (Set)this.tatamiManager.getTatamisForCategories(categories).get(category)) {
            Set<Long> set = this.lockedTatamis;
            synchronized (set) {
                while (this.lockedTatamis.contains(tatami.getTatamiId())) {
                    try {
                        this.lockedTatamis.wait();
                    }
                    catch (Exception exception) {}
                }
                this.lockedTatamis.add(tatami.getTatamiId());
            }
            try {
                ArrayList<FightOrder> fights = new ArrayList<FightOrder>(this.tatamiManager.getFightOrderForTatami(tatami));
                for (FightOrder fightOrder : new LinkedList(fights)) {
                    if (fightOrder.getMatch() == null) continue;
                    Match match = fightOrder.getMatch();
                    Category categoryForMatch = this.categoryManager.getCategoryForMatch(match);
                    if (!category.getCategoryId().equals(categoryForMatch.getCategoryId())) continue;
                    fights.remove(fightOrder);
                }
                this.checkList(fights);
                this.tatamiManager.setFightOrderForTatami(tatami, fights);
            }
            catch (Throwable e) {
                log.error("Error while removing matches for category", e);
            }
            set = this.lockedTatamis;
            synchronized (set) {
                this.lockedTatamis.remove(tatami.getTatamiId());
                this.lockedTatamis.notifyAll();
            }
        }
    }
}

