/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.Page;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.dl.dao.CategoryGroupDAO;
import si.nevensrok.jtekma.server.management.CategoryGroupManager;

@Transactional(value="jtekmaTransactionManager")
public class CategoryGroupManagerImpl
implements CategoryGroupManager {
    private static final Logger log = LoggerFactory.getLogger(CategoryGroupManagerImpl.class);
    private CategoryGroupDAO categoryGroupDAO;

    public void setCategoryGroupDAO(CategoryGroupDAO categoryGroupDAO) {
        this.categoryGroupDAO = categoryGroupDAO;
    }

    public CategoryGroup createCategoryGroup(CategoryGroup categoryGroup) {
        log.debug("Creating category group: {}", (Object)categoryGroup);
        return (CategoryGroup)this.categoryGroupDAO.create((Pojo)categoryGroup);
    }

    public CategoryGroup updateCategoryGroup(CategoryGroup categoryGroup) {
        log.debug("Updating category group: {}", (Object)categoryGroup);
        return (CategoryGroup)this.categoryGroupDAO.update((Pojo)categoryGroup);
    }

    public void deleteCategoryGroup(CategoryGroup categoryGroup) {
        log.debug("Deleting category group: {}", (Object)categoryGroup);
        this.categoryGroupDAO.setCategoriesForGroup(categoryGroup, new LinkedList());
        this.categoryGroupDAO.delete((Pojo)categoryGroup);
    }

    public CategoryGroup getCategoryGroupById(Long categoryGroupId) {
        return (CategoryGroup)this.categoryGroupDAO.getById((Object)categoryGroupId);
    }

    public Page<CategoryGroup> findCategoryGroups(Competition competition, Page<CategoryGroup> page) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(page.getFilter());
        page.setFilter((Filter)rootFilter);
        return this.categoryGroupDAO.find(page, false);
    }

    public CategoryGroup getCategoryGroupByName(Competition competition, String name) {
        return this.categoryGroupDAO.getCategoryGroupByName(competition, name);
    }

    public void setCategoriesForGroup(CategoryGroup categoryGroup, List<Category> categories) {
        this.categoryGroupDAO.setCategoriesForGroup(categoryGroup, categories);
    }

    public List<Category> getCategoriesForGroup(CategoryGroup categoryGroup) {
        return this.categoryGroupDAO.getCategoriesForGroup(categoryGroup);
    }

    public void setCategoryGroupsForCategory(Category category, List<CategoryGroup> categoryGroups) {
        this.categoryGroupDAO.setCategoryGroupsForCategory(category, categoryGroups);
    }

    public List<CategoryGroup> getCategoryGroupsForCategory(Category category) {
        return this.categoryGroupDAO.getCategoryGroupsForCategory(category);
    }

    public boolean isInCategoryGroup(CategoryGroup categoryGroup, Category category) {
        return this.categoryGroupDAO.isInCategoryGroup(categoryGroup, category);
    }
}

