/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.jobs;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matchupload.NextMatchUpload;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.NextMatchUploadManager;

public class NextMatchUploadJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(NextMatchUploadJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            log.debug("Next match upload job started");
            ApplicationContext applicationContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
            if (applicationContext == null) {
                throw new RuntimeException("ApplicationContext not found");
            }
            long nextMatchUploadId = context.getJobDetail().getJobDataMap().getLong("nextMatchUploadId");
            if (nextMatchUploadId <= 0L) {
                throw new RuntimeException("NextMatchUploadId not found");
            }
            NextMatchUploadManager nextMatchUploadManager = (NextMatchUploadManager)applicationContext.getBean("jtekmaNextMatchUploadManager");
            if (nextMatchUploadManager == null) {
                throw new RuntimeException("NextMatchUploadManager not found");
            }
            NextMatchUpload nextMatchUpload = nextMatchUploadManager.getNextMatchUploadById(Long.valueOf(nextMatchUploadId));
            if (nextMatchUpload == null) {
                this.unscheduleJob(context);
                throw new RuntimeException("NextMatchUpload not found");
            }
            if (nextMatchUpload.getStatus() != NextMatchUpload.Status.ACTIVE) {
                log.debug("NextMatchUpload [{}] is not active", (Object)nextMatchUpload);
                this.unscheduleJob(context);
                return;
            }
            CompetitionManager competitionManager = (CompetitionManager)applicationContext.getBean("jtekmaCompetitionManager");
            if (competitionManager == null) {
                throw new RuntimeException("CompetitionManager not found");
            }
            Competition competition = competitionManager.getCompetitionForNextMatchUpload(nextMatchUpload);
            if (competition == null) {
                this.unscheduleJob(context);
                throw new RuntimeException("Competition not found");
            }
            if (nextMatchUpload.getStatus() != NextMatchUpload.Status.ACTIVE) {
                log.debug("Competition [{}] is not active", (Object)competition);
                this.unscheduleJob(context);
                return;
            }
            if (this.isJobAlreadyRunning(context)) {
                log.debug("Next match upload job is already running");
                return;
            }
            nextMatchUploadManager.executeUpload(nextMatchUpload);
            log.debug("Next match upload job finished");
        }
        catch (Exception e) {
            log.error("Error executing next match upload job", (Throwable)e);
        }
    }

    private void unscheduleJob(JobExecutionContext context) {
        log.debug("Unscheduling next match upload [{}],[{}]", (Object)context.getTrigger().getKey().getName(), (Object)context.getTrigger().getKey().getGroup());
        try {
            context.getScheduler().unscheduleJob(context.getTrigger().getKey());
        }
        catch (Exception e) {
            log.error("Error unscheduling next match upload", (Throwable)e);
        }
    }

    private boolean isJobAlreadyRunning(JobExecutionContext context) throws SchedulerException {
        int jobCounter = 0;
        for (JobExecutionContext jobExecutionContext : context.getScheduler().getCurrentlyExecutingJobs()) {
            if (!jobExecutionContext.getTrigger().getKey().equals((Object)context.getTrigger().getKey())) continue;
            ++jobCounter;
        }
        return jobCounter > 1;
    }
}

