/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.settings.util;

import java.io.File;

public class SystemInfo {
    public static SystemOS getSystemOS() {
        if (System.getProperty("os.name").contains("Windows")) {
            return SystemOS.WINDOWS;
        }
        if (System.getProperty("os.name").contains("Linux")) {
            return SystemOS.LINUX;
        }
        if (System.getProperty("os.name").contains("Mac")) {
            return SystemOS.MACOSX;
        }
        return null;
    }

    public static Arhitecture getArchitecture() {
        if (System.getProperty("os.arch").compareTo("x86") == 0) {
            return Arhitecture.x86;
        }
        if (System.getProperty("os.arch").compareTo("amd64") == 0) {
            return Arhitecture.amd64;
        }
        if (System.getProperty("os.arch").compareTo("x86_64") == 0) {
            return Arhitecture.x86_64;
        }
        return null;
    }

    public static File getUserHomeDir() {
        File dir;
        String homeDir = System.getenv("HOME");
        if (homeDir == null && (homeDir = System.getenv("HOMEPATH")) != null) {
            String homeDrive = System.getenv("HOMEDRIVE");
            homeDir = homeDrive + homeDir;
        }
        if (homeDir != null && (dir = new File(homeDir)).isDirectory()) {
            return dir;
        }
        return null;
    }

    public static enum Arhitecture {
        x86,
        amd64,
        x86_64;

    }

    public static enum SystemOS {
        WINDOWS,
        LINUX,
        MACOSX;

    }
}

