/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.SystemTrustStore;
import si.nevensrok.common.utils.RegexUtil;
import si.nevensrok.common.x509cert.CertificateUtil;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class KeystoreTrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = LoggerFactory.getLogger(KeystoreTrustManager.class);
    private boolean trustAll = false;
    private boolean checkDate = true;
    private boolean checkHostname = true;
    private KeyStore trustStore;

    public KeystoreTrustManager() {
        this.trustStore = SystemTrustStore.getSystemTrustStore();
    }

    public KeystoreTrustManager(boolean trustAll) {
        this.trustAll = trustAll;
        this.trustStore = SystemTrustStore.getSystemTrustStore();
    }

    public KeystoreTrustManager(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public KeystoreTrustManager(KeyStore trustStore, boolean checkDate) {
        this.trustStore = trustStore;
        this.checkDate = checkDate;
    }

    public KeystoreTrustManager(KeyStore trustStore, boolean checkDate, boolean checkHostname) {
        this.trustStore = trustStore;
        this.checkDate = checkDate;
        this.checkHostname = checkHostname;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        LinkedList<X509Certificate> trustedSigners = new LinkedList<X509Certificate>();
        try {
            Enumeration<String> aliasEnumerator = this.trustStore.aliases();
            while (aliasEnumerator.hasMoreElements()) {
                String alias = aliasEnumerator.nextElement();
                try {
                    X509Certificate certificate = (X509Certificate)this.trustStore.getCertificate(alias);
                    trustedSigners.add(certificate);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.trace("Error fetching accpeted issuers", (Throwable)e);
        }
        return trustedSigners.toArray(new X509Certificate[0]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        X509Certificate certificate = this.checkChain(chain);
        if (!this.trustAll && this.checkHostname && socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String hostname = session.getPeerHost();
            if (!this.verifyHostname(hostname, certificate)) {
                throw new CertificateException("Hostname validation failed");
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        X509Certificate certificate = this.checkChain(chain);
        if (!this.trustAll && this.checkHostname && engine != null) {
            SSLSession session = engine.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("No handshake session");
            }
            String hostname = session.getPeerHost();
            if (!this.verifyHostname(hostname, certificate)) {
                throw new CertificateException("Hostname validation failed");
            }
        }
    }

    private X509Certificate checkChain(X509Certificate[] chain) throws CertificateException {
        if (this.trustAll) {
            return chain[0];
        }
        if (this.trustStore == null) {
            throw new CertificateException("Truststore empty");
        }
        if (chain.length < 1) {
            throw new CertificateException("Certificate chain empty");
        }
        if (this.checkDate) {
            for (X509Certificate certificate : chain) {
                certificate.checkValidity();
            }
        }
        for (X509Certificate certificate : chain) {
            if (!this.isRevoked(certificate)) continue;
            throw new CertificateException("Certificate revoked");
        }
        try {
            for (int i = 0; i < chain.length - 1; ++i) {
                if (!CertificateUtil.isUsedForSigning(chain[i + 1])) {
                    throw new CertificateException("Certificate is not verified for signing");
                }
                chain[i].verify(chain[i + 1].getPublicKey());
            }
        }
        catch (Exception e) {
            log.trace("Certificate chain is not valid", (Throwable)e);
            throw new CertificateException("Certificate chain is not valid");
        }
        try {
            Enumeration<String> aliasEnumerator = this.trustStore.aliases();
            while (aliasEnumerator.hasMoreElements()) {
                String alias = aliasEnumerator.nextElement();
                try {
                    X509Certificate signer = (X509Certificate)this.trustStore.getCertificate(alias);
                    if (!this.checkDate) {
                        signer.checkValidity();
                    }
                    if (this.isRevoked(signer)) {
                        throw new CertificateException("Certificate revoked");
                    }
                    chain[chain.length - 1].verify(signer.getPublicKey());
                    return chain[0];
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            log.trace("Error checking system CA keytore", (Throwable)e);
        }
        throw new CertificateException("Certificate is not trustvorthy");
    }

    public boolean isRevoked(X509Certificate certificate) {
        return false;
    }

    public boolean verifyHostname(String hostname, X509Certificate certificate) {
        try {
            if (hostname.startsWith("[") && hostname.endsWith("]")) {
                hostname = hostname.substring(1, hostname.length() - 1);
            }
            X500Name name = CertificateUtil.getName((X509CertImpl)certificate);
            String commonName = name.getCommonName();
            String regex = RegexUtil.createWildcardRegex(commonName);
            if (hostname.toLowerCase().matches(regex.toLowerCase())) {
                return true;
            }
            List<String> alternativeNames = CertificateUtil.getAlternativeNames(certificate);
            for (String alternativeName : alternativeNames) {
                String regex2 = RegexUtil.createWildcardRegex(alternativeName);
                if (!hostname.toLowerCase().matches(regex2.toLowerCase())) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error("Error checking hostname", (Throwable)e);
        }
        return false;
    }
}

