/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.smssender.advert2you;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import si.nevensrok.common.smssender.BackgroundSmsSender;
import si.nevensrok.common.smssender.SmsMessage;
import si.nevensrok.common.smssender.SmsMessageResponse;

public class Advert2YouSmsSender
extends BackgroundSmsSender
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Advert2YouSmsSender.class);
    public static final int ERRORCODE_INVALIDAUTH = 1;
    public static final int ERRORCODE_MESSAGETOOLONG = 2;
    public static final int ERRORCODE_INVALIDSENDER = 3;
    public static final int ERRORCODE_INVALIDRECIPIENT = 4;
    public static final int ERRORCODE_SERVERERROR = 5;
    public static final int ERRORCODE_INSUFFICIENTFUNDS = 6;
    public static final int ERRORCODE_SENDERNOTREGISTRED = 7;
    public static final int ERRORCODE_INVALIDXML = 8;
    public static final int ERRORCODE_MORETHAT50MESSAGESINPACKAGE = 9;
    private String address = "http://api.advert2you.com/SendPackage.aspx";
    private String username;
    private String password;
    private String encoderCharset = "ASCII";
    private String postAddress;

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEncoderCharset(String encoderCharset) {
        this.encoderCharset = encoderCharset;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Initializing advert2you sms message sender");
        }
        if (this.username == null) {
            throw new IllegalArgumentException("Property 'username' is required");
        }
        if (this.password == null) {
            throw new IllegalArgumentException("Property 'password' is required");
        }
        this.postAddress = this.address + "?sUserName=" + URLEncoder.encode(this.username, this.encoderCharset) + "&sPassword=" + URLEncoder.encode(this.password, this.encoderCharset);
        super.afterPropertiesSet();
    }

    @Override
    public SmsMessageResponse sendSmsMessage(SmsMessage smsMessage) {
        HttpURLConnection urlConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            SmsMessageResponse response = new SmsMessageResponse();
            URL url = new URL(this.postAddress);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element packageElement = document.createElement("package");
            document.appendChild(packageElement);
            Element messageElement = document.createElement("message");
            packageElement.appendChild(messageElement);
            Element senderElement = document.createElement("sender");
            senderElement.setTextContent(smsMessage.getFrom());
            messageElement.appendChild(senderElement);
            Element receiverElement = document.createElement("receiver");
            receiverElement.setTextContent(smsMessage.getTo());
            messageElement.appendChild(receiverElement);
            Element messageContentElement = document.createElement("message");
            messageContentElement.setTextContent(smsMessage.getMessageText());
            messageElement.appendChild(messageContentElement);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.connect();
            outputStream = urlConnection.getOutputStream();
            OutputFormat outputFormat = new OutputFormat("XML", "UTF-8", false);
            XMLSerializer serializer = new XMLSerializer(outputStream, outputFormat);
            serializer.asDOMSerializer();
            serializer.serialize(document.getDocumentElement());
            outputStream.flush();
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                inputStream = urlConnection.getInputStream();
                Document responseDocument = docBuilder.parse(inputStream);
                Element responsePackageElement = responseDocument.getDocumentElement();
                NodeList smsIdNodeList = responsePackageElement.getElementsByTagName("smsid");
                if (smsIdNodeList.getLength() > 0) {
                    for (int i = 0; i < smsIdNodeList.getLength(); ++i) {
                        Node smsIdNode = smsIdNodeList.item(i);
                        if (smsIdNode.getNodeType() != 1) continue;
                        String smsId = smsIdNode.getTextContent();
                        response.setSuccess(true);
                        response.setSmsId(smsId);
                        break;
                    }
                } else {
                    response.setSuccess(false);
                    response.setErrorCode(responsePackageElement.getTextContent());
                    response.setErrorMessage("Sms not send. Check error code.");
                    log.error("Returned error code: {}", (Object)responsePackageElement.getTextContent());
                }
                inputStream.close();
                outputStream.close();
            } else {
                response.setSuccess(false);
                response.setErrorMessage("Invalid HTTP response code: " + responseCode);
                log.error("Invalid HTTP response code: {}", (Object)responseCode);
            }
            urlConnection.disconnect();
            return response;
        }
        catch (Exception e) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                urlConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error("Error sending sms message", (Throwable)e);
            return new SmsMessageResponse(false, null, null, "General exeption");
        }
    }
}

