/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import si.nevensrok.common.cache.AbstractCacheManager;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.hazelcast.HazelcastCache;

public class HazelcastCacheManager
extends AbstractCacheManager
implements InitializingBean {
    private HazelcastInstance hazelcastInstance;
    private String namePrefix = "cache.";
    private Map<String, HazelcastCache> cacheStore = new LinkedHashMap<String, HazelcastCache>();

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.hazelcastInstance == null) {
            throw new IllegalArgumentException("Property 'hazelcastInstance' must be specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(String name) {
        HazelcastCache cache;
        Map<String, HazelcastCache> map = this.cacheStore;
        synchronized (map) {
            cache = this.cacheStore.get(name);
            if (cache == null) {
                CacheSettings settings = this.getCacheSettings().get(name);
                if (settings == null) {
                    settings = this.getDefaultCacheSettings();
                }
                cache = new HazelcastCache(name, settings, this.hazelcastInstance, this.namePrefix);
                this.cacheStore.put(name, cache);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCacheNames() {
        Map<String, HazelcastCache> map = this.cacheStore;
        synchronized (map) {
            return new LinkedList<String>(this.cacheStore.keySet());
        }
    }
}

