/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.mail;

import java.util.Calendar;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.mail.Attachment;
import si.nevensrok.common.mail.BackgroundMailSender;
import si.nevensrok.common.mail.Email;
import si.nevensrok.common.mail.MailSender;

public class SmtpMailSender
extends BackgroundMailSender
implements MailSender,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SmtpMailSender.class);
    private String hostname = "localhost";
    private int port = 25;
    private String charsetName = "UTF8";
    private String username = null;
    private String password = null;
    private boolean useStartTsl = false;
    private boolean trustAllHosts = false;
    private boolean debug = false;
    private Session session = null;

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        if (this.username != null && this.username.isEmpty()) {
            this.username = null;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        if (this.password != null && this.password.isEmpty()) {
            this.password = null;
        }
    }

    public boolean isUseStartTsl() {
        return this.useStartTsl;
    }

    public void setUseStartTsl(boolean useStartTsl) {
        this.useStartTsl = useStartTsl;
    }

    public boolean isTrustAllHosts() {
        return this.trustAllHosts;
    }

    public void setTrustAllHosts(boolean trustAllHosts) {
        this.trustAllHosts = trustAllHosts;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        boolean useAuth;
        log.debug("Initializing mail sender");
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.hostname);
        properties.put("mail.smtp.port", String.valueOf(this.port));
        properties.put("mail.mime.charset", this.charsetName);
        if (this.useStartTsl) {
            properties.put("mail.smtp.starttls.enable", "true");
        }
        if (this.trustAllHosts) {
            properties.put("mail.smtp.ssl.trust", "*");
        }
        boolean bl = useAuth = this.username != null && this.password != null;
        if (useAuth) {
            log.debug("Using username & password authentication");
            properties.put("mail.smtp.auth", "true");
        }
        this.session = useAuth ? Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SmtpMailSender.this.username, SmtpMailSender.this.password);
            }
        }) : Session.getInstance((Properties)properties);
        this.session.setDebug(this.debug);
        log.debug("Mail sender initialized");
        super.afterPropertiesSet();
    }

    @Override
    public Message sendEmail(Email email) {
        log.debug("Sending email: {}", (Object)email);
        try {
            Address[] addresses;
            MimeMessage message = new MimeMessage(this.session);
            if (email.getAttachments() == null || email.getAttachments().isEmpty()) {
                message.setContent((Object)email.getBody(), "text/html; charset=utf-8;");
            } else {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart messageBody = new MimeBodyPart();
                messageBody.setContent((Object)email.getBody(), "text/html; charset=utf-8;");
                multipart.addBodyPart((BodyPart)messageBody);
                for (Attachment attachment : email.getAttachments()) {
                    MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                    attachmentBodyPart.setDataHandler(new DataHandler((DataSource)attachment));
                    attachmentBodyPart.setFileName(attachment.getName());
                    multipart.addBodyPart((BodyPart)attachmentBodyPart);
                }
                message.setContent((Multipart)multipart);
            }
            message.setSubject(email.getSubject());
            message.setFrom((Address)new InternetAddress(email.getFrom()));
            if (email.getRecipients() != null && !email.getRecipients().isEmpty()) {
                addresses = new Address[email.getRecipients().size()];
                int n = 0;
                for (String recipient : email.getRecipients()) {
                    addresses[n++] = new InternetAddress(recipient);
                }
                message.setRecipients(Message.RecipientType.TO, addresses);
            }
            if (email.getRecipientsCC() != null && !email.getRecipientsCC().isEmpty()) {
                addresses = new Address[email.getRecipientsCC().size()];
                int n = 0;
                for (String recipient : email.getRecipientsCC()) {
                    addresses[n++] = new InternetAddress(recipient);
                }
                message.setRecipients(Message.RecipientType.CC, addresses);
            }
            if (email.getRecipientsBCC() != null && !email.getRecipientsBCC().isEmpty()) {
                addresses = new Address[email.getRecipientsBCC().size()];
                int n = 0;
                for (String recipient : email.getRecipientsBCC()) {
                    addresses[n++] = new InternetAddress(recipient);
                }
                message.setRecipients(Message.RecipientType.BCC, addresses);
            }
            message.setSentDate(Calendar.getInstance().getTime());
            Transport.send((Message)message);
            log.debug("Email sent: {}", (Object)email);
            return message;
        }
        catch (Exception e) {
            log.error("Error while sending email", (Throwable)e);
            throw new RuntimeException("Error while sending email", e);
        }
    }
}

