/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.cache;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import si.nevensrok.common.cache.CacheSettings;
import si.nevensrok.common.cache.CachedValue;

public abstract class AbstractCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(AbstractCache.class);
    private String name;
    private CacheSettings cacheSettings;

    public AbstractCache(String name, CacheSettings cacheSettings) {
        this.name = name;
        this.cacheSettings = cacheSettings;
    }

    public String getName() {
        return this.name;
    }

    public CacheSettings getCacheSettings() {
        return this.cacheSettings;
    }

    public Object getNativeCache() {
        return this;
    }

    public abstract CachedValue get(Object var1);

    public <T> T get(Object key, Class<T> type) {
        CachedValue cachedValue = this.get(key);
        if (cachedValue == null || cachedValue.get() == null) {
            return null;
        }
        if (type.isAssignableFrom(cachedValue.get().getClass())) {
            return (T)cachedValue.get();
        }
        return null;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        CachedValue cachedValue = this.get(key);
        if (cachedValue == null) {
            try {
                T value = valueLoader.call();
                this.put(key, value);
                return value;
            }
            catch (Throwable e) {
                log.warn("Error loading value", e);
                return null;
            }
        }
        try {
            return (T)cachedValue.get();
        }
        catch (Throwable e) {
            log.warn("Cached value is invalid type", e);
            return null;
        }
    }

    public CachedValue putIfAbsent(Object key, Object value) {
        CachedValue cachedValue = this.get(key);
        if (cachedValue == null) {
            this.put(key, value);
        }
        return cachedValue;
    }

    public boolean isCacheValid(CachedValue cachedValue) {
        if (cachedValue.getValidUntil() == null) {
            return true;
        }
        return System.currentTimeMillis() <= cachedValue.getValidUntil();
    }

    public Long generateValidUntil() {
        Long ttl = this.cacheSettings.getTimeToLive();
        if (ttl != null) {
            return System.currentTimeMillis() + ttl;
        }
        return null;
    }
}

